#include "mbed.h"
#include "C12832.h"

InterruptIn joystickcenter(p14);
InterruptIn button(p9);
DigitalOut led(LED1);
DigitalOut flash(LED4);
C12832 lcd(p5, p7, p6, p8, p11);

// global declarations
Timer debounce;
int i;

// instructions
void flip()
{
    // local declarations
    if (debounce.read_ms() > 1000) {
        i = 1;
        debounce.reset();
        led = !led;                     // toggles the led when the joystick button is pressed.
    }
}

int main()
{
    joystickcenter.rise(&flip);         // attach the function address to the rising edge
    button.mode(PullUp);                  // With this, no external pullup resistor needed
    button.rise(&flip);                   // attach the function address to the rising edge
    debounce.start();
    while(1) {                      // wait around, interrupts will interrupt this!
        flash = !flash;             // turns LED4 on if off, off if on
        wait(0.25);                 // the instruction to wait for half-second
        if(i==1) {
            lcd.locate(0,0);
            lcd.printf("%d", debounce.read_ms());
            i = 0;
        }
    }
}
