#include "mbed.h" 
Serial pc(USBTX, USBRX); // tx, rx defines an object called pc of class Serial and points it at the USB port
PwmOut led(LED1); // Pwm stand for pulse width modulation and led is an object of class PwmOut
float brightness = 0.0; //brightness is a variable of type float (which means a real number)
int main() { 
    pc.printf("Press 'u' to turn LED1 brightness up, 'd' to turn it down\n"); // outputs a message at the start once
    
    while(1) { // do forever
        char c = pc.getc(); // defines a variable c of type char and sets it to a character received from Tera Term
        if((c == 'u') && (brightness < 0.5)) { 
            pc.putc('^');
            brightness += 0.01; // equivalent brightness = brightness + 0.01
            led = brightness; 
        } 
        if((c == 'd') && (brightness > 0.0)) { 
            pc.putc('v');
            brightness -= 0.01; 
            led = brightness; 
        } 
    } 
}