#include "mbed.h"
#include "C12832.h"
Timer debounce;              //Timer class declaring the object call it debounce
int i;
C12832 lcd(p5,p6,p7,p8,p11);
InterruptIn joystickcenter(p14);// input joystic center pin 14
InterruptIn button(p9);
DigitalOut led(LED1);         // output LED 1
DigitalOut flash(LED4);       // output LED 4
void flip() {                 // function
 led = !led;                  // toggles the led when the joystick button is pressed.
 i = 1;
}
int main() {
 joystickcenter.rise(&flip);  // attach the function address to the rising edge
 button.mode(PullUp);         // With this, no external pullup resistor needed
 button.rise(&flip);          // attach the function address to the rising edge
 while(1) {                   // wait around, interrupts will interrupt this!
 debounce.start();            // start timer
 if(debounce.read_ms() > 50000){ // set timer to 50000 ms
     i=1;
     debounce.reset();        // get ready for next time
     led=!led;
     lcd.locate(0,0);
     lcd.printf("Button pressed");
     i=0;
     }
 flash = !flash;              // turns LED4 on if off, off if on
 wait(0.25);                  // the instruction to wait for a quarter-second
 }
}

