#include "mbed.h"
#include "C12832.h"               //library
C12832 lcd(p5,p6,p7,p8,p11);
InterruptIn joystickcenter(p14);  // input joystic center pin 14
InterruptIn button(p9);           // input button pin 9
DigitalOut led(LED1);             // output LED 1
DigitalOut flash(LED4);           // output LED 4
Timer debounce;                   //Timer class declaring the object call it debounce
int i;
void flip()                       //function
{
    if (debounce.read_ms() > 5000) {//set timer to 5000ms
    led = !led;                   // led on when the joystick button is pressed.          
    debounce.reset ();
    i=1;    
    }
    }
    int main() {
        joystickcenter.rise(&flip);// attach the function address to the rising edge
        button.mode(PullUp);      // With this, no external pullup resistor needed
        button.rise(&flip);       // attach the function address to the rising edge
        debounce.start();
        while(1) {                // wait around, interrupts will interrupt this!
            flash = !flash;       // turns LED4 on if off, off if on
            wait(0.5);            // the instruction to wait for half-second
            i=0;
                      if(i==1) {
                lcd.locate(0,0);           
                lcd.printf("%d", debounce.read_ms()); //print on lcd debounce value
                i=0;
            }     

       }
 }     
                   