#include "mbed.h"

InterruptIn joystick_Reset(p14); // Configure InterruptIn object with p14, which corresponds to joystick reset function
InterruptIn joystick_Down(p12);// configure InteruptIn object with p12, which corresponds to jotstick Down function
InterruptIn joystick_Left(p13);// configure InteruptIn object with p13, which corresponds to jotstick Left function
InterruptIn joystick_Up(p15);// configure InteruptIn object with p15, which corresponds to jotstick Up function
InterruptIn joystick_Right(p16);// configure InteruptIn object with p16, which corresponds to jotstick Right function
DigitalOut myLED(LED4); // Has to be LED1-4, not a pin

void toggle(void);

int main()
{
    joystick_Reset.rise(&toggle); // Attach the address of the toggle to the rising edge
    joystick_Down.rise(&toggle);
    joystick_Left.rise(&toggle);
    joystick_Up.rise(&toggle);
    joystick_Right.rise(&toggle);
}

void toggle()
{
    myLED=!myLED;
    if (joystick_Reset==1)
        printf("we toggled p14 centre\r\n");
    else ;
    if (joystick_Down==1)
        printf("we toggled p12 down\r\n");
    else ;
    if (joystick_Left==1)
        printf("we toggled p13 left\r\n");
    else ;
    if (joystick_Up==1)
        printf("we toggled p15 up\r\n");
    else ;
    if (joystick_Right==1)
        printf("we toggled p16 right\r\n");
    else ;

}