#include "mbed.h"
#include "EthernetInterface.h"
 
#define MBED_DEV_IP       "192.168.5.61"
#define MBED_DEV_MASK     "255.255.255.0"
#define MBED_DEV_GW       "192.168.5.1"
#define ECHO_SERVER_PORT   5000
#define SERVER_CLIENT_PORT 5001
#define PORT_HTTP 80

#define HTTP_GET_300POLITYKA ("GET /stan-gry/ HTTP/1.0\r\nHost: 300polityka.pl\r\n\r\n")
//#define HTTP_GET_300POLITYKA ("GET / HTTP/1.0\r\nHost: 192.168.5.73\r\n\r\n")
#define IP_300POLITYKA ("178.32.202.241")
//#define IP_300POLITYKA ("192.168.5.73")

//Serial pc(USBTX, USBRX);

void eth_vTaskTimeReq(){
    int socketFd;
    int len;
    struct sockaddr_in clientSockDescr, serverSockDescr;
    char buf[1024];
    char httpGetReq[]= HTTP_GET_300POLITYKA;

    socketFd = lwip_socket(AF_INET, SOCK_STREAM, 0);
    if (socketFd < 0)
        return;

    memset( (char *)&clientSockDescr, 0, sizeof(clientSockDescr) );
    memset( (char *)&serverSockDescr, 0, sizeof(serverSockDescr) );

    clientSockDescr.sin_family = AF_INET;
    clientSockDescr.sin_len = sizeof(clientSockDescr);
    clientSockDescr.sin_addr.s_addr = inet_addr(MBED_DEV_IP);
    clientSockDescr.sin_port = htons(SERVER_CLIENT_PORT);

    serverSockDescr.sin_family = AF_INET;
    serverSockDescr.sin_len = sizeof(serverSockDescr);
    serverSockDescr.sin_addr.s_addr = inet_addr(IP_300POLITYKA);
    serverSockDescr.sin_port = htons(PORT_HTTP);

    if ( lwip_bind(socketFd, (struct sockaddr *)&clientSockDescr, sizeof(struct sockaddr_in)) == -1 ){
        printf("\nBind failed\n");  
        return;
    }
    printf("\nBind succeed\n");
    
    while(1){
        if( lwip_connect( socketFd, (struct sockaddr*)(&serverSockDescr), sizeof( struct sockaddr_in ) ) == 0 ){
            if( lwip_send( socketFd, httpGetReq, strlen(httpGetReq), 0) >= 0 ){
                do{
                    len= lwip_recv( socketFd, buf, sizeof(buf), 0 );
                    if ( len>0 ){
                       printf(buf);// setDateTime( buf, *( (int*)pvParameters ) );
                    }
                }  while ( len>0 );
                printf("\nSend succeed\n"); 
            }
              
        }
        printf("\nConnect failed\n"); 
        break;
    }
        lwip_close(socketFd);
}
 
int main (void) {
    EthernetInterface eth;
    eth.init(MBED_DEV_IP, MBED_DEV_MASK, MBED_DEV_GW); //Assign a device ip, mask and gateway
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    eth_vTaskTimeReq();
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    
    while (true) {
        printf("\nWait for new connection...\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 15000); // Timeout after (1.5)s
        
        printf("Connection from: %s\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            printf("%s\n", buffer);
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        
        client.close();
    }
}