/*mV_mero_01.cpp
********KL25Z********

input: 100K poti GND - P3V3 - A2(PTB2)

*/
#include "mbed.h"
#include "USBSerial.h"
#include "TextLCD.h" 

TextLCD lcd(PTB8, PTB9, PTB10, PTB11, PTE2, PTE3); // rs, e, d4-d7 Aruino pin

//Virtual serial port over USB
USBSerial serial;
AnalogIn AnIn(PTB2);        //A2
DigitalOut K_led(LED1);     //blue led
int main(void) {
    float volume=0;                         // displays init...
    K_led=0;                                        
    lcd.cls();
    lcd.printf("*mV Measuring *\n");        // LCD
    lcd.printf("   --StART--   \n");
    serial.printf("*mV Measuring *\n");     //USB SERIEL (HiperTerminal)
    serial.printf("   --StART--   \n");
    wait(2);
    lcd.cls();                  // TextLCD.h 
    while(1)
    {
        volume=int(AnIn.read()*2880);
        lcd.locate(0,0);
        lcd.printf("Volume:%f",volume);
        lcd.locate(13,0);
        lcd.printf(" mV   ");
        serial.printf("Volume:(%f) \r",volume);
        wait(0.25);
        K_led=!K_led;
    }
}