//imp_mess_007.cpp
//***********************
//*  Pulse measurement  *
//***********************
/* D0-ra jel sorozat a USB Flight Simulator-ról, egy npn tranyós jelszint erősítő és fázis fordítón keresztül
 * 
 *                         min: 420us
 * D0 . . . __________[]___[]___[]_[]___[]___[]___[]___[]_______ . . . ___[]___[]___[]___[]___[]___[]___[]______ . . . 
                      ^^   ^^    ^ ^     ^   ^          ^                 ^   
                      trigers    Ch3      Ch5             szinkron impulzus

 * input = D0(PTA1)
 * trigger imp.:   ~400 us
 * Max. imp.:     ~1500 us
 * Min. imp.:      ~760 us
 * Szinkron imp.  >8000 us
*/


#include "mbed.h"
#include "TextLCD.h"

InterruptIn int1(D0);

TextLCD lcd(PTB8, PTB9, PTB10, PTB11, PTE2, PTE3); // rs, e, d4-d7 Aruino lábkiosztással

extern int imp = 0;
extern int Ch1 = 0;   // Ch1 - Ch7 megjelenítő tároló
extern int Ch2 = 0;
extern int Ch3 = 0;
extern int Ch4 = 0;
extern int Ch5 = 0;
extern int Ch6 = 0;
extern int Ch7 = 0;
extern unsigned Ch_counter = 0;  //csatorna számláló

Timer timer1;


DigitalOut K_led(LED1);
DigitalOut Z_led(LED2);
DigitalOut P_led(LED3);


//************************************************
//************************************************
void szinkron(){
    //megnézi aktuális Imp szinkron jel-e Imp>3000
    //Ch1=imp;
    //return;
    if (imp>float(5000)){
        Ch_counter = 7;  //csatorna számláló    
        imp = 0;
        return;
    }
    switch(Ch_counter){
        case 7:
            //P_led=0;
            Ch1 = imp;
            Ch_counter--;
            break;
        case 6:
            //P_led=0;
            Ch2 = imp;
            Ch_counter--;
            break;
        case 5:
            Ch3 = imp;
            Ch_counter--;
            break;
        case 4:
            Ch4 = imp;
            Ch_counter--;
            break;
        case 3:
            Ch5 = imp;
            Ch_counter--;
            break;
        case 2:
            Ch6 = imp;
            lcd.locate(0,0);                // LCD
            lcd.printf(":%d \n", Ch1);
            lcd.locate(5,0);
            lcd.printf(":%d \n", Ch2);
            lcd.locate(11,0);
            lcd.printf(":%d \n", Ch3);
            lcd.locate(0,1);
            lcd.printf(":%d \n", Ch4);
            lcd.locate(5,1);
            lcd.printf(":%d \n", Ch5);
            lcd.locate(11,1);
            lcd.printf(":%d \n", Ch6);
            Ch_counter--;
            break;
        default:
            Ch7 = imp;
            break;
    }
}
//************************************************
void tm1_start() {
    //Z_led=0;
    timer1.start();
}
//************************************************
void tm1_stop() {
    //P_led=0;
    imp=timer1.read_us();
    timer1.stop();
    timer1.reset();
    szinkron();
}
//************************************************
//************************************************
int main() {
    K_led=1;
    Z_led=1;
    P_led=1;
    lcd.cls();
    lcd.printf("Pulse measuremen\n");
    lcd.printf("imp_mess_007.cpp\n");
    wait(1);
    lcd.cls();                  // TextLCD.h ban leirt fuggveny
    
    int1.fall(&tm1_start);   //Piros
    int1.rise(&tm1_stop);   //Zöld
    while(1) {
        K_led = !K_led;
        wait(0.25);
        
        
    }
}
