#ifndef TOUCHMENU_H
#define TOUCHMENU_H
#include "bip.h"
#include "TSISensor.h"
#include "mbed.h"
#include "GLCD_spi.h"

//*******************************************
/*   TouchRun osztály
// Példányosítás:  TouchRun TchR;
//
*/
class TouchRun{
public:
    TouchRun();        // Konstruktor
    //~TouchRun();       // Destructor
    int touch_run(void);
private: 
    void kurzor(void);
    void kurzor_torles(void);
    void kep(void);
    void akcio(void);
 
    char buffer[22]; 
    int touch_status;
    int touch_value;
    int T_value;
    int a;
    TSISensor tsi;
    Timer touch_timer;
};
//*******************************************

//** Fügvény definició **********************


//-------------------------------------------
//-------------------------------------------
void TouchRun::kurzor(){
    lcd_string(touch_value+1,1,">>");
}

//-------------------------------------------
void TouchRun::kurzor_torles(){
    lcd_string(2,0,"    ");
    lcd_string(3,0,"    ");
    lcd_string(4,0,"    ");    
    lcd_string(5,0,"    ");
    lcd_string(6,0,"    ");        
    
}
//-------------------------------------------
void TouchRun::akcio(){
    int touch=0;
    touch = int(tsi.readPercentage()*100);                   // vissza adott érték:
    if(touch==0){touch_value=0; return;}
    if(touch>0 & touch<33)  {touch_value=1; return;}       // [<]        z_villan();
    if(touch>32 & touch<66) {touch_value=2; return;}      // [ent]       z_villan();
    if(touch>65 & touch<101){touch_value=3; return;}     // [>]          z_villan();
    return;
    
}
//-------------------------------------------
void TouchRun::kep(){
    //lcd_cls();
    lcd_string(7,0,"<--> <Ent> <++> ");
}
//-------------------------------------------
int TouchRun::touch_run(){           //  Touch állapotgép
    //DigitalOut K_LED(LED3);

    switch(touch_status){
        case 0:             // állókép kiírása
            //K_LED = 1;
            kep();
            T_value=1;
            touch_status++;        
            return 0;
        case 1:                     // akció???
            akcio();                // Melyik gombot nyomta meg? : touch_value = 0 semmi, =1 [<], =2 [ENter], =3 [>]
            if(touch_value>0){      // Ha volt akció, tovább lép
                Bip(2,1);
                touch_status++; 
            }
            sprintf(buffer,">%d<",touch_value);
            lcd_string(7,18,buffer);
            return(touch_value);
        case 2:             // akció volt
            //kurzor();
            //K_LED = 0;
            
            touch_timer.reset();    //késleltet
            touch_timer.start();
            touch_status++;
            return 0;
        case 3:             // timer túl csordult???
            a= touch_timer.read_ms();
            if(a > int(300)){
                touch_timer.stop();
                
                touch_status++;
            }
            return 0;
        case 4:             // kúrzor megjelenítése
            //kurzor_torles();
            touch_status=1; //touch_status++;
            return 0;
    }
    return 0;
}


//*******************************************
TouchRun::TouchRun(){       //Konstruktor
    touch_status = 0;
    touch_value = 0;
    //DigitalOut P_LED(LED1), Z_LED(LED2), K_LED(LED3);

}
//TouchRun::~TouchRun(){}     //Destructor
//*******************************************
//*******************************************





//*******************************************
/*TouchMenu 
// Meghívás:       b = TchM.menu_run(a);       //Fő menü
// (a) Meghívás paramétere: megadja melyik menüsort jelenitse meg a kép függvény
// (b) Visszatérési paraméter: megadja melyik sorról nyomott <Enter>-t (touch_value)
//
*/

    int menu_run(int);
    TouchRun TchR1;

    void mstart(int);
    int mkurzor(int);
    void kurzor_torles(void);
    void akcio(void);

    int t_value;
    int m_kurzor;
    int m_kurzor_old;
    char buffer[22]; 
    int menu_status;
    int menu_value;
    int M_value;
    int mk_value;
    TSISensor tsi;
    Timer menu_timer;
    
//** Fügvény definiciók **********************
void mstart(int a){
    char menu_chr[10][7][15] = { 
    {"FRMD KL25Z ","   RTC menu   ","   Acc menu   ","   MMG menu   ","   Press menu ","   SET menu   ","   Fo  menu   ",},
    {"RTC menu   ","   Date Set   ","   Time Set   ","   Alarm Set  ","   RTC RUN    ","              ","   Fo  menu   ",},
    {"Acc menu   ","   Acc 1      ","   Acc 2      ","   Acc 3      ","   Acc RUN    ","              ","   Fo  menu   ",},
    {"MMG menu   ","   MMG 1      ","   MMG 2      ","   MMG 3      ","   MMG4       ","              ","   Fo  menu   ",},
    {"Press menu ","   Press1     ","   Press2     ","   Press3     ","   Press4     ","              ","   Fo  menu   ",},
    {"SET menu   ","   RTC Set    ","   6.  2      ","   6.  3      ","   6. 4       ","              ","   Fo  menu   ",},
    {"Date Set m.","   Year Set   ","   Month set  ","   Day set    ","   Week set   ","              ","   Fo  menu   ",}, //RTC
    {"Time Set m.","   Hour Set   ","   Minute set ","   Second set ","              ","              ","   Fo  menu   ",}, //RTC
    {"AlarmSet m.","  AHour Set   ","  AMinute set ","  ASecond set ","              ","              ","   Fo  menu   ",}, //RTC
    {"RTC RUN    ","   Start      ","   STOP       ","              ","              ","              ","   Fo  menu   ",}, //RTC
                                };
    
    //lcd_string(0,5,menu_chr[a][0]);
    lcd_string(1,0,menu_chr[a][1]);
    lcd_string(2,0,menu_chr[a][2]);
    lcd_string(3,0,menu_chr[a][3]);
    lcd_string(4,0,menu_chr[a][4]);
    lcd_string(5,0,menu_chr[a][5]);
    lcd_string(6,0,menu_chr[a][6]);

    lcd_line(0,7,128,7,char(1));
    lcd_line(0,55,128,55,char(1));
    m_kurzor = 1;
    m_kurzor_old = 1;

}
//-------------------------------------------
int mkurzor(int delta){
    m_kurzor = m_kurzor_old + delta;
    if(m_kurzor<1){m_kurzor=6;}
    if(m_kurzor>6){m_kurzor=1;}
    lcd_string(m_kurzor_old,0,"  ");
    lcd_string(m_kurzor,0,"->");
    m_kurzor_old = m_kurzor;
    return m_kurzor;
}
//-------------------------------------------
//-------------------------------------------
int menu_run(int a){
    menu_status=0;
    while(1){
        switch(menu_status){
            case 0:
                mstart(a);
                mk_value = mkurzor(0);
                menu_status++; 
                break;
            case 1:
                t_value = TchR1.touch_run();
                if(t_value>0){
                    menu_status++;  
                }
                break;
            case 2:
                menu_status = 1;
                switch(t_value){
                    case 1:
                        mk_value = mkurzor(-1);
                        break;
                    case 3:
                        mk_value = mkurzor(1);
                        break;
                    case 2:
                        sprintf(buffer,"=>%d",mk_value);
                        lcd_string(6,15,buffer);
                        return mk_value;                      
                }
                break;
        }
    }
//    return 0;
}
//------------------------------------------------
void SendBox(){     //buffer[12] -ben van a szöveg változó
    
    
    lcd_string(1,2,"                ");
    lcd_string(2,2,"                ");    
    lcd_string(3,2,"                ");    
    lcd_string(4,2,"     SendBox    ");    
    lcd_string(5,2,"                ");    
    lcd_string(6,2,"                ");    
    lcd_string(3,4,buffer);    

    lcd_line(18,10,110,10,char(1));
    lcd_line(110,10,110,50,char(1));
    lcd_line(110,50,18,50,char(1));
    lcd_line(18,50,18,10,char(1));
    wait(2);
    lcd_line(18,10,110,10,char(0));
    lcd_line(110,10,110,50,char(0));
    lcd_line(110,50,18,50,char(0));
    lcd_line(18,50,18,10,char(0));

}
//--------------------------------------------------------
int SetBox(int value, int min, int max){             ////buffer[12] -ben van a szöveg változó
    TouchRun TchR2;
    int t_value;
    
    lcd_string(1,2,"                ");
    lcd_string(2,2,"    SetBox      ");    
    lcd_string(3,2,"                ");    
    lcd_string(4,2,"                ");    
    lcd_string(5,2,"                ");    
    lcd_string(6,2,"                ");    
    lcd_string(4,4,buffer);    
    sprintf(buffer,"%d", value);
    lcd_string(4,9,buffer);
    lcd_line(18,10,110,10,char(1));
    lcd_line(110,10,110,50,char(1));
    lcd_line(110,50,18,50,char(1));
    lcd_line(18,50,18,10,char(1));
    while(1){
        t_value = TchR2.touch_run();    
        switch(t_value){
            case 0:
            break;
            case 1:     //-- 0-99 között lehet
                value--;
                if(value<min){value = max;}
            break;
            case 2:     // Ent.
                return value;
            case 3:     //++  0-99 között lehet
                value++;
                if(value>max){value = min;}
            break;    
        }
        //sprintf(buffer,"  ");
        //lcd_string(4,9,buffer);
        sprintf(buffer,"\b\b%d ", value);
        lcd_string(4,9,buffer);
 
    }
}
//----------------------------------------------
void BoxClear(){
    lcd_line(18,10,110,10,char(0));
    lcd_line(110,10,110,50,char(0));
    lcd_line(110,50,18,50,char(0));
    lcd_line(18,50,18,10,char(0));

    
}
#endif