#ifndef RTC_H
#define RTC_H

#include "mbed.h"
#include "GLCD_spi.h"
#include "TouchMenu.h"

#define RTC8563 0xA2

#define CONTROL1 0x00
#define CONTROL2 0x01
#define SECONDS 0x02
#define MINUTES 0x03
#define HOURS 0x04
#define DAYS 0x05
#define WEEKDAYS 0x06
#define MONTHS 0x07
#define YEARS 0x08
#define MINUTE_ALARM 0x09
#define HOUR_ALARM 0x0A
#define DAY_ALARM 0x0B
#define WEEKDAY_ALARM 0x0C
#define CLOCKOUT_FREQ 0x0D
#define TIMER_CINTROL 0x0E
#define TIMER 0x0F
#define _READ 0x01

I2C i2c(PTE0, PTE1);    //SDA, SCL
TouchRun TchR2;
DigitalOut K_LED(LED1), P_LED(LED3), Z_LED(LED2);


char year, month, day, week, hour, minute, sec;
int iyear, imonth, iday, iweek, ihour, iminute, isec;
char ntp_year[3], ntp_month[3], ntp_day[3], ntp_week[4];
char ntp_hour[3], ntp_minute[3], ntp_sec[3];
char week_val;

char week_chr[7][4] = {"Vas","Het","Ked","Sze","Csu","Pen","Szo"};
//-------------------------------------------------------------------    
void rtc_write(char address, char value){
    i2c.start();
    i2c.write(RTC8563);
    i2c.write(address);
    i2c.write(value);
    i2c.stop();
}
//-------------------------------------------------------------------
char rtc_read(char address){
    char value;
    i2c.start();
    i2c.write(RTC8563);
    i2c.write(address);
    i2c.start();
    i2c.write(RTC8563 | _READ);
    value = i2c.read(0);
    i2c.stop();
    
    return value;
}
//-------------------------------------------------------------------
void time_just(){
    char _min, _hour;
    //test_led = !test_led;
    _min = rtc_read(MINUTES);
    if (_min >= 0x30) { 
            _hour = rtc_read(HOURS);
            if (_hour == 0x23)
                _hour = 0x00;
            else if ((_hour & 0x0F) == 0x09)
                _hour = (_hour & 0xF0) + 0x10;
            else
                _hour = _hour + 0x01;
            rtc_write(HOURS, _hour);
    }
    rtc_write(MINUTES, 0x00);
    rtc_write(SECONDS, 0x00);
}
//------------------------------------------------------------------    
void rtc_reset(){
    //just_button.rise(&time_just);

    lcd_cls();
    lcd_string(2,1,"RTC8563 CLOCK RESET" );
    wait(1);
    
    rtc_write(CONTROL1, 0x20); //stop
    rtc_write(CONTROL2, 0x00);
    rtc_write(YEARS, 0x36);                   //((ntp_year[0]-0x30)<<4)+(ntp_year[1]-0x30)); 
    rtc_write(MONTHS,0x02);                   //((ntp_month[0]-0x30)<<4)+(ntp_month[1]-0x30));
    rtc_write(DAYS, 0x03);                    //((ntp_day[0]-0x30)<<4)+(ntp_day[1]-0x30));
    rtc_write(HOURS, 0x04);                    //((ntp_hour[0]-0x30)<<4)+(ntp_hour[1]-0x30));
    rtc_write(MINUTES,0x05);                  //((ntp_minute[0]-0x30)<<4)+(ntp_minute[1]-0x30));
    rtc_write(SECONDS,0x00);                  //((ntp_sec[0]-0x30)<<4)+(ntp_sec[1]-0x30));
    rtc_write(WEEKDAYS, week_val);
    rtc_write(CLOCKOUT_FREQ, 0x00); // 0x83 = TE on & 1Hz
    rtc_write(TIMER_CINTROL, 0x00);
    rtc_write(CONTROL1, 0x00); //start
} 
//------------------------------------------------------------------   
void rtc_data_read(){ 
    i2c.start();
    i2c.write(0xA2);
    i2c.write(0x02);
    i2c.stop();
    i2c.start();
    i2c.write(0xA3);
    sec = i2c.read(SECONDS)     & 0x7F;
    minute = i2c.read(MINUTES)  & 0x7F;
    hour = i2c.read(HOURS)      & 0x3F;
    day = i2c.read(DAYS)        & 0x3F;
    week = i2c.read(WEEKDAYS)   & 0x07;
    month = i2c.read(MONTHS)    & 0x1F;
    year = i2c.read(YEARS);
    i2c.stop();
    
    
    //lcd.locate(0,0);
    sprintf(buffer,"%c%c/%c%c/%c%c %s",
        ((year >> 4) & 0x0F) + 0x30, (year & 0x0F) + 0x30,              //int((year >> 4)& 0x0F)*10 + int(year & 0x0F), 
            ((month >> 4) & 0x01) + 0x30, (month & 0x0F) + 0x30, 
                ((day >> 4) & 0x03)+ 0x30, (day & 0x0F) + 0x30, 
                    week_chr[week & 0x07]);
    lcd_string(0,0,buffer);
    //lcd.locate(0,1); 
    sprintf(buffer,"%c%c:%c%c:%c%c",
        ((hour >> 4) & 0x03) + 0x30, (hour & 0x0F) + 0x30, 
            (minute >> 4) + 0x30, (minute & 0x0F) + 0x30, 
                (sec >> 4) + 0x30, (sec & 0x0F) + 0x30 );
    lcd_string(0,13,buffer);
}
//--------------------------------------------------------------
void rtc_data_set(){
 
    rtc_data_read();
    //--------------------------------------------------    
    year = (int)((((year >> 4)& 0x0F)*10) + (year & 0x0F));
   
    sprintf(buffer,"Year: ");
    year = SetBox(year, 0, 99);
    Bip(1,1);
    
    sprintf(buffer,"%d",year);
    if(year > 9){                 // két helyiértékesetén
        year = buffer[0] & 0x0F;
        year = (year<<4) + (buffer[1] & 0x0F);
    }else{                      // egy helyiérték esetén
        year = buffer[0] & 0x0F;
    }
    // a visszaalakítás azonos mint a beolvasásnál
    //sprintf(buffer,"Year:%c%c", ((year >> 4) & 0x0F) + 0x30, (year & 0x0F) + 0x30);
    //lcd_string(5,0,buffer);
    //--------------------------------------------------
    month = (int)((((month >> 4)& 0x01)*10) + (month & 0x0F));
   
    sprintf(buffer,"Month: ");
    month = SetBox(month, 1, 12);
    Bip(1,1);
    
    sprintf(buffer,"%d",month);
    if(month > 9){                 // két helyiértékesetén
        month = buffer[0] & 0x0F;
        month = (month<<4) + (buffer[1] & 0x0F);
    }else{                      // egy helyiérték esetén
        month = buffer[0] & 0x0F;
    }
    //--------------------------------------------------
    day = (int)((((day >> 4)& 0x03)*10) + (day & 0x0F));
   
    sprintf(buffer,"Day: ");
    day = SetBox(day, 1, 31);
    Bip(1,1);
    
    sprintf(buffer,"%d",day);
    if(day > 9){                 // két helyiértékesetén
        day = buffer[0] & 0x0F;
        day = (day<<4) + (buffer[1] & 0x0F);
    }else{                      // egy helyiérték esetén
        day = buffer[0] & 0x0F;
    }

    //--------------------------------------------------
    week = (int)((((week >> 4)& 0x03)*10) + (week & 0x0F));
   
    sprintf(buffer,"Week: ");
    week = SetBox(week + 1, 1, 7);
    Bip(1,1);
    
    sprintf(buffer,"%d",week - 1);
    if(week > 9){                 // két helyiértékesetén
        week = buffer[0] & 0x0F;
        week = (week<<4) + (buffer[1] & 0x0F);
    }else{                      // egy helyiérték esetén
        week = buffer[0] & 0x0F;
    }

   //--------------------------------------------------
    hour = (int)((((hour >> 4)& 0x03)*10) + (hour & 0x0F));
   
    sprintf(buffer,"Hour: ");
    hour = SetBox(hour, 0, 23);
    Bip(1,1);
    
    sprintf(buffer,"%d",hour);
    if(hour > 9){                 // két helyiértékesetén
        hour = buffer[0] & 0x0F;
        hour = (hour<<4) + (buffer[1] & 0x0F);
    }else{                      // egy helyiérték esetén
        hour = buffer[0] & 0x0F;
    }

   //--------------------------------------------------
    minute = (int)((((minute >> 4)& 0x07)*10) + (minute & 0x0F));
   
    sprintf(buffer,"Minute: ");
    minute = SetBox(minute, 0, 23);
    Bip(1,1);
    
    sprintf(buffer,"%d",minute);
    if(minute > 9){                 // két helyiértékesetén
        minute = buffer[0] & 0x0F;
        minute = (minute<<4) + (buffer[1] & 0x0F);
    }else{                      // egy helyiérték esetén
        minute = buffer[0] & 0x0F;
    }
    //-------------------------------------------------

    rtc_write(CONTROL1, 0x20);                  //stop       
    rtc_write(CONTROL2, 0x00);
    rtc_write(YEARS, year);                   //((ntp_year[0]-0x30)<<4)+(ntp_year[1]-0x30)); 
    rtc_write(MONTHS,month);
    rtc_write(DAYS, day);
    rtc_write(WEEKDAYS,week);
    rtc_write(HOURS, hour);
    rtc_write(MINUTES, minute);
    rtc_write(SECONDS,0x00);
    rtc_write(CONTROL1, 0x00); //start
}







#endif