#ifndef GLCDSPI_H
#define GLCDSPI_H

/*** GLCD_spi.h***
*  Új változat  char* int_string(int)
* MCP23S17 - Microchip MCP23S17 16-bit Port Extender using SPI
* Copyright (c) 2010 Gert van der Knokke
*/
#include "mbed.h"

// for 21 characters on a row (6x8 font)
#define LCDFONTSEL  0xFF
// for 16 characters on a row (8x8 font)
// #define LCDFONTSEL 0xDF

#define IODIRA      0x00
#define IODIRB      0x01
#define IPOLA       0x02
#define IPOLB       0x03
#define GPINTENA    0x04
#define GPINTENB    0x05
#define DEFVALA     0x06
#define DEFVALB     0x07
#define INTCONA     0x08
#define INTCONB     0x09
#define IOCONA      0x0A
#define IOCONB      0x0B
#define GPPUA       0x0C
#define GPPUB       0x0D
#define INTFA       0x0E
#define INTFB       0x0F
#define INTCAPA     0x10
#define INTCAPB     0x11
#define GPIOA       0x12
#define GPIOB       0x13
#define OLATA       0x14
#define OLATB       0x15

// LCD pin connections/bit numbers
#define LCD_HALT    0x80
#define LCD_FS      0x20
#define LCD_RST     0x10
#define LCD_CD      0x08
#define LCD_CE      0x04
#define LCD_RD      0x02
#define LCD_WR      0x01

//      T6963C OPCODES
#define TXHOME      0x40    // SET TXT HOME ADDRESS
#define TXAREA      0x41    // SET TXT AREA
#define GRHOME      0x42    // SET GRAPHIC HOME ADDRESS
#define GRAREA      0x43    // SET GRAPHIC AREA
#define OFFSET      0x22    // SET OFFSET ADDRESS
#define ADPSET      0x24    // SET ADDRESS POINTER
#define AWRON       0xB0    // SET AUTO WRITE MODE
#define AWROFF      0xB2    // RESET AUTO WRITE MODE


/* This file contains definitions for all of the commands in a t6963. */
/********************************************************************/
/*  Register set */
#define CPS 0x21 //Cursor pointer set
#define ORS 0x22 //Offset register set
#define APS 0x24 //Address pointer set
#define THAS 0x40 //Text home address set
#define TAS 0x41 //Text area set
#define GHAS 0x42 //Graphic home address set
#define GAS 0x43 //Graphic area set
#define OM 0x80 //OR mode
#define EM 0x81 //EXOR mode
#define AM 0x83 //AND mode
#define TAM 0x84 //TEXT ATTRIBUTE mode
#define DOF 0x90 //Display OFF
#define CONBOF 0x92 //Cursor ON, Blink OFF
#define CONBON 0x93 //Cursor ON, Blink ON
#define TONGOF 0x94 //Text ON, Graphic OFF
#define TOFGON 0x98 //Text OFF, Graphic ON
#define TONGON 0x9C //Text ON, Graphic ON
#define LC1 0xA0 //1 Line cursor
#define LC2 0xA1 //2 Line cursor
#define LC3 0xA2 //3 Line cursor
#define LC4 0xA3 //4 Line cursor
#define LC5 0xA4 //5 Line cursor
#define LC6 0xA5 //6 Line cursor
#define LC7 0xA6 //7 Line cursor
#define LC8 0xA7 //8 Line cursor
#define DAWS 0xB0 //Data auto write set
#define DARS 0xB1 //Data auto read set
#define AR 0xB2 //Auto reset
#define DWAAI 0xC0 //Data write and ADP increment
#define DRAAI 0xC1 //Data read and ADP increment
#define DWAAD 0xC2 //Data write and ADP decrement
#define DRAAD 0xC3 //Data read and ADP decrement
#define DWAAN 0xC4 //Data write and ADP nonvariable
#define DRAAN 0xC5 //Data read and ADP nonvariable
#define SP 0xE0 //Screen PEEK
#define SC 0xE8 //Screen COPY
#define BR 0xF0 //Bit RESET
#define BS 0xF8 //Bit SET
//add 3 bit data to these
//commands to select bit

// for 21 characters on a row (6x8 font)
#define LCDFONTSEL  0xFF
// for 16 characters on a row (8x8 font)
// #define LCDFONTSEL 0xDF

// lcd dimensions in pixels
#define LCD_XWIDTH     128
#define LCD_YHEIGHT    64

#if LCDFONTSEL == 0xFF
// lcd dimensions in characters
#define LCD_WIDTH   22
#define LCD_HEIGHT  16
#define PIXELWIDTH  6
#else
#define LCD_WIDTH   16
#define LCD_HEIGHT  16
#define PIXELWIDTH  8
#endif

#define TEXT_STARTADDRESS       0x0000
#define GRAPHIC_STARTADDRESS    0x1000

   
#define CENTERX 50
#define CENTERY 32
#define INNER_RADIUS    20
#define OUTER_RADIUS    25
#define CENTER_CIRCLE   5

extern char d[14]={0};  // inttochar() visszaadott érték string-je 

//DigitalOut K_LED(LED1), P_LED(LED3), Z_LED(LED2);
SPI spi(PTC6, PTC7, PTC5);  // mosi, miso, sclk
DigitalOut cs2(PTC10);       //CS1=PTC11; CS2=PTC10; CS3=PTC4 Hardware CS a panelon
//----------------------------------------------------
void SPI_init()
{
    // set SPI to full speed (10 MHz mode)
    spi.format(8,0);
    spi.frequency(10000000);
    //spi.frequency(10000);
}
//----------------------------------------------------

void lcd_data(unsigned char d)  // write 8 bits lcd data
{
    cs2=0;
    spi.write(0x40);
    spi.write(GPIOB);  // select GPIOB
    spi.write(d);      // set data byte
    cs2=1;

    cs2=0;
    spi.write(0x40);
    spi.write(GPIOA);  // select GPIOA
    spi.write(LCDFONTSEL-LCD_CE-LCD_CD);   
    cs2=1;

    cs2=0;
    spi.write(0x40);
    spi.write(GPIOA);  // select GPIOA
    spi.write(LCDFONTSEL - LCD_WR - LCD_CE - LCD_CD);   
    cs2=1;

    cs2=0;
    spi.write(0x40);
    spi.write(GPIOA);  // select GPIOA
    spi.write(LCDFONTSEL - LCD_CD);   
    cs2=1;
    
}
//----------------------------------------------------

void lcd_command(unsigned char c)   // write 8 bits lcd command
{
    cs2=0;
    spi.write(0x40);
    spi.write(GPIOB);  // select GPIOB
    spi.write(c);      // set data byte
    cs2=1;

    cs2=0;
    spi.write(0x40);
    spi.write(GPIOA);  // select GPIOA
    spi.write(LCDFONTSEL-LCD_CE);   
    cs2=1;

    cs2=0;
    spi.write(0x40);
    spi.write(GPIOA);  // select GPIOA
    spi.write(LCDFONTSEL - LCD_WR - LCD_CE);   
    cs2=1;

    cs2=0;
    spi.write(0x40);
    spi.write(GPIOA);  // select GPIOA
    spi.write(LCDFONTSEL);   
    cs2=1;
}
//----------------------------------------------------
void lcd_init()     //Grafikus LCD initializálása
{
    cs2=0;
    spi.write(0x40);
    spi.write(IODIRA);  // select IODIRA at start
    spi.write(0x00);    // IODIRA all outputs
    spi.write(0x00);    // IODIRB all outputs
    cs2=1;
    wait(0.1);
    
    cs2=0;
    spi.write(0x40);
    spi.write(GPIOA);  // select GPIOA at start
    spi.write(LCDFONTSEL-LCD_RST);    // activate reset
    spi.write(0x00);    // all B outputs 0
    cs2=1;
    wait(0.1);

    cs2=0;
    spi.write(0x40);
    spi.write(GPIOA);  // select GPIOA at start
    spi.write(LCDFONTSEL);    // deactivate reset
    cs2=1;
    wait(0.1);

    // set text home address at 0x0000
    lcd_data(TEXT_STARTADDRESS%0x100);
    lcd_data(TEXT_STARTADDRESS/0x100);
    lcd_command(TXHOME);
    
    // set graphic home address at 0x1000
    lcd_data(GRAPHIC_STARTADDRESS%0x100);
    lcd_data(GRAPHIC_STARTADDRESS/0x100);
    lcd_command(GRHOME);
    
    // set text area 
    lcd_data(LCD_WIDTH);
    lcd_data(0x00);
    lcd_command(TXAREA);

    // set graphic area
    lcd_data(LCD_WIDTH);
    lcd_data(0x00);
    lcd_command(GRAREA);
    
    // mode set (internal character generation mode)
    lcd_command(0x80);
    
    // set offset register
    lcd_data(0x02);
    lcd_data(0x00);
    lcd_command(OFFSET);
    
    // display mode (text on graphics on cursor off)
    lcd_command(0x90+0x08+0x04);
        
}
//-------------------------------------------------

//------------------------------------------------------
char* int_string(double da){    // elő nullák nélküli kiíratás

    int b,c,dx,i;  //b=adott helyiértéken a számjegy, c=0 akkor elő nulla; dx= az elő nullák nélküli helyiérték száma
    char* f;        // egy karakter tipusú változó pointere
    c=0;
    dx=0;
    for(i=0;i<15;i++){d[i]=char(0x00);}
    //teszt adat: 
    //da=123456;
    b=int(da/100000000);    // 9. helyiérték
    if(b>0){c=1;d[dx]=0x30 | char(b);dx++;}
    da = da - b*100000000;  // 8. helyiérték
    b=int(da/10000000);
    if(b>0 | c>0){c=1;d[dx]=0x30 | char(b);dx++;}
    da = da - b*10000000;  // 7. helyiérték
    b=int(da/1000000);
    if(b>0 | c>0){c=1;d[dx]=0x30 | char(b);dx++;}
    da = da - b*1000000;  // 6. helyiérték
    b=int(da/100000);
    if(b>0 | c>0){c=1;d[dx]=0x30 | char(b);dx++;}
    da = da - b*100000;  // 5. helyiérték
    b=int(da/10000);
    if(b>0 | c>0){c=1;d[dx]=0x30 | char(b);dx++;}
    da = da - b*10000;  // 4. helyiérték
    b=int(da/1000);
    if(b>0 | c>0){c=1;d[dx]=0x30 | char(b);dx++;}
    da = da - b*1000;  // 3. helyiérték
    b=int(da/100);
    if(b>0 | c>0){c=1;d[dx]=0x30 | char(b);dx++;}
    da = da - b*100;  // 2. helyiérték
    b=int(da/10);
    if(b>0 | c>0){c=1;d[dx]=0x30 | char(b);dx++;}
    da = da - b*10;  // 1. helyiérték
    b=int(da);
    if(b>0 | c>0){c=1;d[dx]=0x30 | char(b);dx++;}
    // visszatérési érték: d[] string
    f = d;  // f tartalmazza a d char tömb pointerét
    return f;
}



//------------------------------------------------------
void lcd_string(char y,char x,char *s)      // put a text string at position x,y (character row,column)
{                                                 
    int adr;
    adr=TEXT_STARTADDRESS+x+y*LCD_WIDTH;    // 0x0000 + x + y + 22
    lcd_data(adr%0x100);                    // % maradék képzés jele
    lcd_data(adr/0x100);
    lcd_command(ADPSET);
    lcd_command(AWRON);
    while (s[0]){
        // convert from ascii to t6963
        lcd_data(s[0]-32);
        s++;
    }
    lcd_command(AWROFF);
}
//----------------------------------------------------
void lcd_cls()      // clear lcd display memory (8k)        
{
    int a;
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_command(ADPSET);
    lcd_command(AWRON);
    for (a=0; a<8192; a++) lcd_data(0);
    lcd_command(AWROFF);
}
//----------------------------------------------------
void lcd_plot(char x,char y,char color)     // set or reset a pixel on the display on position x,y with color 0 or 1
{
    int adr;                         
    adr = GRAPHIC_STARTADDRESS + ((LCD_WIDTH) * y) + (x/PIXELWIDTH);   // calculate offset
    lcd_data(adr%0x100);       // set low byte
    lcd_data(adr/0x100);       // set high byte
    lcd_command(ADPSET);           // set address pointer
    if (color) lcd_command(BS + ((PIXELWIDTH-1)-(x%PIXELWIDTH)));   // use bit set mode
        else  lcd_command(BR + ((PIXELWIDTH-1)-(x%PIXELWIDTH)));  // use bit reset mode
}
//----------------------------------------------------

void lcd_line(int x0, int y0, int x1, int y1,char color)        // Bresenham line routine 0-128 x 0-64 color= char(1)
{                                                               // color 1, 0
    char steep=1;
    int i,dx,dy,e;
    signed char sx,sy;
    
    dx = abs(x1-x0);
    sx = ((x1 - x0) >0) ? 1 : -1;
    dy=abs(y1-y0);
    sy = ((y1 - y0) >0) ? 1 : -1;
    
    if (dy > dx)
    {
        steep=0;
        // swap X0 and Y0
        x0=x0 ^ y0;
        y0=x0 ^ y0;
        x0=x0 ^ y0;

        // swap DX and DY
        dx=dx ^ dy;
        dy=dx ^ dy;
        dx=dx ^ dy;

        // swap SX and SY
        sx=sx ^ sy;
        sy=sx ^ sy;
        sx=sx ^ sy;
    }

    e = (dy << 1) - dx;

    for (i=0; i<=dx; i++)
    {
        if (steep)
        {
            lcd_plot(x0,y0,color);
        }
        else
        {
            lcd_plot(y0,x0,color);
        }
        while (e >= 0)
        {
            y0 += sy;
            e -= (dx << 1);
        }
        x0 += sx;
        e += (dy << 1);
    }
 }
//----------------------------------------------------

// kör kirajzolása
void lcd_circle(int x0,int y0, int radius, char color)      // Bresenham circle routine
{
    int i;
    float cx =1.3;       // kör rajzolás  LCD torzítás kompenzálása
    i=0;
    //char sa[3];
    int f = 1 - radius;
    int dx = 1;
    int dy = -2 * radius;
    int x = 0;
    int y = radius;
    //float cx =1.3;
    lcd_plot(x0 * cx, y0 + radius,color);
    lcd_plot(x0 * cx, y0 - radius,color);
    lcd_plot((x0 + radius) * cx, y0,color);
    lcd_plot((x0 - radius) * cx, y0,color);
 
    while(x < y){
        i++;
        if(f >= 0) 
        {
            y--;
            dy += 2;
            f += dy;
        }
        x++;
        dx += 2;
        f += dx;    
        lcd_plot((x0 + x) * cx, y0 + y,color);
        //a=(x0+x)*cx;
        //glcd_inttochar(a);
        //lcd_string(0,0,d);
        //a= y0 + y;
        //glcd_inttochar(a);
        //lcd_string(12,0,d);
        lcd_plot((x0 - x) * cx, y0 + y,color);
        lcd_plot((x0 + x) * cx, y0 - y,color);
        lcd_plot((x0 - x) * cx, y0 - y,color);
        lcd_plot((x0 + y) * cx, y0 + x,color);
        lcd_plot((x0 - y) * cx, y0 + x,color);
        lcd_plot((x0 + y) * cx, y0 - x,color);
        lcd_plot((x0 - y) * cx, y0 - x,color);
        //wait(.2);
    }
}

#endif