#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"

AnalogIn Vin(PTC2);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalIn button1(PTC12);
DigitalIn button2(PTC13);
DigitalIn button3(PTC16);
DebouncedIn button4(PTC17);



int C1=0x0F;
int spnum=0,kinum=0,kpnum=0,kdnum=0,pos=1;
int incremento=1,decremento=1,flagt=0;
Timer t;

int main()
{
    lcd.cls(); // Borrar Pantalla
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD

    lcd.locate(8,0);
    lcd.printf("Kp=%d",kpnum);
    lcd.locate(0,1);
    lcd.printf("Ki=%d",kinum);
    lcd.locate(8,1);
    lcd.printf("Kd=%d",kdnum);
    lcd.locate(0,0);
    lcd.printf("Sp=%d",spnum);
    
    while(1)
    {
        if (!button1)
        {
            if(flagt==0)
            {
                t.start();
                flagt=1;
            }

            led1 =!led1;
            wait(0.50);
            if(!button1)
            {
                if(t.read()>10)
                {
                    incremento=100;
                }
                else if(t.read()>5.5)
                {
                    incremento=10;
                }

                if(pos==1)
                {
                    if(spnum+incremento>=999)
                    {
                        spnum=999;
                        lcd.locate(3,0);
                        lcd.printf("    ");
                        lcd.locate(3,0);
                        lcd.printf("%d", spnum);
                    }
                    else
                    {
                        spnum+=incremento;
                        lcd.locate(3,0);
                        lcd.printf("%d", spnum);
                    }                        
                }
                else if(pos==2)
                {
                    if(kpnum+incremento>=999)
                    {
                        kpnum=999;
                        lcd.locate(11,0);
                        lcd.printf("    ");
                        lcd.locate(11,0);
                        lcd.printf("%d", kpnum);
                    }
                    else
                    {
                        kpnum+=incremento;
                        lcd.locate(11,0);
                        lcd.printf("%d", kpnum);
                    }
                }
                else if(pos==3)
                {
                    if(kinum+incremento>=999)
                    {
                        kinum=999;
                        lcd.locate(3,1);
                        lcd.printf("    ");
                        lcd.locate(3,1);
                        lcd.printf("%d", kinum);
                    }
                    else
                    {
                        kinum+=incremento;
                        lcd.locate(3,1);
                        lcd.printf("%d", kinum);
                    }
                }
                else if(pos==4)
                {
                    if(kdnum+incremento>=999)
                    {
                        kdnum=999;
                        lcd.locate(11,1);
                        lcd.printf("    ");
                        lcd.locate(11,1);
                        lcd.printf("%d", kdnum);
                    }
                    else
                    {
                        kdnum+=incremento;
                        lcd.locate(11,1);
                        lcd.printf("%d", kdnum);
                    }
                }
            }
        }
        
        if (!button2)
        {
            if(flagt==0)
            {
                t.start();
                flagt=1;
            }

            led1 =!led1;
            wait(0.50);
            if(!button2)
            {
                if(t.read()>10)
                {
                    decremento=100;
                }
                else if(t.read()>5.5)
                {
                    decremento=10;
                }

                if(pos==1)
                {
                    
                    if(spnum>=999)
                    {
                        spnum=999;
                        lcd.locate(3,0);
                        lcd.printf("    ");
                        lcd.locate(3,0);
                        lcd.printf("%d", spnum);

                    }

                    else
                    {
                        if(spnum==0)
                    {   spnum=0;
                        lcd.locate(0,0);
                        lcd.printf("Sp=%d",spnum);
                        lcd.locate(3,0);
                        lcd.printf("%d", spnum);
                        }
                        
                        spnum-=decremento;
                        lcd.locate(3,0);
                        lcd.printf("%d", spnum);
                    }                        
                }
                else if(pos==2)
                {
                    if(kpnum>=999)
                    {
                        kpnum=999;
                        lcd.locate(11,0);
                        lcd.printf("    ");
                        lcd.locate(11,0);
                        lcd.printf("%d", kpnum);
                    }
                    else
                    {
                        kpnum-=decremento;
                        lcd.locate(11,0);
                        lcd.printf("%d", kpnum);
                    }
                }
                else if(pos==3)
                {
                    if(kinum>=999)
                    {
                        kinum=999;
                        lcd.locate(3,1);
                        lcd.printf("    ");
                        lcd.locate(3,1);
                        lcd.printf("%d", kinum);
                    }
                    else
                    {
                        kinum-=decremento;
                        lcd.locate(3,1);
                        lcd.printf("%d", kinum);
                    }
                }
                else if(pos==4)
                {
                    if(kdnum>=999)
                    {
                        kdnum=999;
                        lcd.locate(11,1);
                        lcd.printf("    ");
                        lcd.locate(11,1);
                        lcd.printf("%d", kdnum);
                    }
                    else
                    {
                        kdnum-=decremento;
                        lcd.locate(11,1);
                        lcd.printf("%d", kdnum);
                    }
                }
            }
        }
        
        
        /*if (!button2)
        {
            if(flagt==0)
            {
                //t.reset();
                t.start();
                flagt=1;
            }

            led1 =!led1;
            wait(0.50);

            if(!button2)
            {
                if(t.read()>10)
                {
                    incremento=100;
                }
                else if(t.read()>5.5)
                {
                    incremento=10;
                }

                led2 =!led2;
                if(pos==1)
                {
                    if(spnum-incremento<0)
                    {
                        //No ocurre nada
                    }
                    else
                    {
                        spnum-=incremento;
                        lcd.locate(3,0);
                        lcd.printf("    ");
                        lcd.locate(3,0);
                        lcd.printf("%d", spnum);
                    }
                }
                else if(pos==2)
                {
                    if(kpnum-incremento<0)
                    {
                        //No ocurre nada
                    }
                    else
                    {
                        kpnum-=incremento;
                        lcd.locate(11,0);
                        lcd.printf("    ");
                        lcd.locate(11,0);
                        lcd.printf("%d", kpnum);
                    }
                }
                else if(pos==3)
                {
                    if(kinum-incremento<0)
                    {
                        //No ocurre nada
                    }
                    else
                    {
                        kinum-=incremento;
                        lcd.locate(3,1);
                        lcd.printf("    ");
                        lcd.locate(3,1);
                        lcd.printf("%d", kinum);
                    }
                }
                else if(pos==4)
                {
                    if(kdnum-incremento<0)
                    {
                        //No ocurre nada
                    }
                    else
                    {
                        kdnum-=incremento;
                        lcd.locate(11,1);
                        lcd.printf("    ");
                        lcd.locate(11,1);
                        lcd.printf("%d", kdnum);
                    }
                }
            }
        }*/

        if (!button3)
        {
            led3 =!led3;
            if(pos==4)
            {
                pos=1;
                lcd.locate(3,0);
                lcd.printf("%d", spnum);
            }
            else if (pos==1)
            {
                pos++;
                lcd.locate(11,0);
                lcd.printf("%d", kpnum);
            }
            else if(pos==2)
            {
                pos++;
                lcd.locate(3,1);
                lcd.printf("%d", kinum);
            }
            else if(pos==3)
            {
                pos++;
                lcd.locate(11,1);
                lcd.printf("%d", kdnum);
            }
            wait(0.25);

        }
        
        if (button1 && button2)
        {
            flagt=0;
            t.reset();
            incremento=1;
        }
       
    }
}
