/*------------------------------------------------------------------------------------------------------------------------------------*/
//  Programa para enviar desde la FRDMKL25Z un mensaje de texto en formatp PDU
//   Como modem usa un celular SIEMENS a56i
//   ENVIAR -----la palabra "ALARMA 1"
//  

//   OJO CON ESTO
//   conector del siemens cable verde es RX conectelo a PTE0  cable blanco es TX conectelo a PTE1
#include "mbed.h"
#include "DebouncedIn.h"
#include "stdio.h"
#include "string.h"
Timer t;
DigitalOut LedVerde(LED2); /*declara el puerto donde conecta el LED2*/
DigitalOut LedRojo(LED1);  /*declara el puerto donde se conecta el LED1*/
DigitalOut LedAzul(LED3);  /*declara el puerto donde se conecta el LED3*/
DebouncedIn button1(PTC12);  //señal que inicia el envio del mensaje
Serial GSM(PTE0,PTE1); //Configura puerto UART de la FRDMKL25Z
Serial pc(USBTX,USBRX);//Configura puerto USB a la consola serial del PC conectado.
void Rx_interrupt(); 
int position=0; /*inicializa variable position*/
int intentos=0; /*inicializa variable intentos*/
int lenpack=6;  /*inicializa variable lenpack*/
int ret=1;      /*inicializa variable ret*/
int longi=0;    /*inicializa variable longi*/
char tel[11];   /*inicializa variable tel*/
char DE[50];    /*inicializa variable DE*/
char buffer[100];   /*inicializa variable buffer*/
char buffermsg[100];    /*inicializa variable buffermsg*/
char buffer1[100];  /*inicializa variable buffer*/
char datos[100];    /*inicializa variable datos*/
char NUMBER[13];    /*inicializa variable NUMBER*/
char resp[6];       /*inicializa variable resp*/
char CMT[]="+CMTI"; /*inicializa variable CMT*/
char tam[2];        /*inicializa variable tam*/
int index;          /*inicializa variable index*/
int count;          /*inicializa variable count*/
int i = 0;          /*inicializa variable i en cero*/
int j = 0;          /*inicializa variable j en cero*/
int c=0;            /*inicializa variable c en cero*/
unsigned char CtrlZ = 0x1A;  // comodin de emision controlZ
bool Flag = false; // bandera 
char r[]=""; //Cadena de recepcion de la trama PDU si se usa!!
char msg[256]; /*cadena del mensaje*/
char char1;
//Flush serial para el buffer
void FlushGSM(void) {  /*funcion para borrar el buffer*/
char1 = 0; /*inicializa la variable char1*/
 while (GSM.readable()){  /*inicia el cilo  infinito que busca los mensajes*/
     char1 = GSM.getc();} /*la funcion getc lee el GSM*/
     return;} /*termina el la limpieza del buffer*/

void callback() { /*devuelve lo que lee el GSM*/
    // Note: you need to actually read from the serial to clear the RX interrupt
    pc.printf("%c\n", GSM.getc());/*muestra en el pc lo que captura el GSM*/
    
}
//****************************************************************************************************************
//esta funcion de abajo lee todo un bufer hasta encontrar CR o LF y el resto lo rellena de
//$, count es lo que va a leer.Lo leido lo mete en buffer que es una cadena previamente definida
//incorpora medida de tiempo si se demora mas de tres segundos retorna fracaso con -1
//**************************************************************************************************************** 
int readBuffer(char *buffer,int count) /*lee el buffer*/
{
    int i=0;  
    t.start();  // start timer
    while(1) { /*inicia el ciclo infinito para leer el buffer*/
        while (GSM.readable()) { /*captura los datos que entran por el puerto GSM*/
            char c = GSM.getc(); /*obtiene los datos que entran por el puerto CSM y los guarda en la variable c*/
            if (c == '\r' || c == '\n') c = '$'; /*condiciona la variable c*/
            buffer[i++] = c; /*almacena en el buffer*/
            if(i > count)break;  /*si se cumplela condicion sale del bucle*/
        }
        if(i > count)break; /*si sale del bucle entra en este condicional*/
        if(t.read() > 3) { /*condiciona a la variable t a ser menor de 3 segundos*/
            t.stop(); /*para la variable t*/
            t.reset();/*reinicia la variable t*/
            break;  /*sale del bucle*/
        }
    }/*termina el ciclico*/
    wait(0.5); /*espera medio segundo*/
    while(GSM.readable()) {  // display the other thing..
        char c = GSM.getc(); /*almacena en la variable c lo que "recoge del puerto GSM"*/
    }
    return 0; /*termina el while*/
}
//********************************************************************************
/* esta funcion de abajo limpia o borra todo un "buffer" de tamaño "count"
lo revisa elemento por elemento y le mete el caracter null que indica fin de cadena
no retorna nada
*/
//***************************************************************************************
void cleanBuffer(char *buffer, int count) /*limpia el buffer*/
{
    for(int i=0; i < count; i++) { /*inicia el contador*/
        buffer[i] = '\0'; /*coloca el ultimo caracter de la cadena*/
    }
}
/* esta funcion de abajo envia un comando parametrizado como cadena
puede ser un comando tipo AT
*/
//***************************************************************************************
void sendCmd(char *cmd) /*envia un comando tipo cmd*/
{
    GSM.puts(cmd); /*envia comando cmd por el puerto GSM*/
}
//****************************************************************************************
/* esta funcion de abajo espera la respuesta de un comando que debe ser identica a la cadena "resp" y un tiempo timeout"
si todo sale bien retorna un cero que en la programacion hay que validar
si algo sale mal ( no se parece o se demora mucho )retorna -1 que debera validarse con alguna expresion logica
*/
//***************************************************************************************
int waitForResp(char *resp, int timeout) /*espera para enviar una respuesta*/
{
    int len = strlen(resp);  /*guarda la longitud de la cadena resp en la variable len*/
    int sum=0; /*inicializa la variable sum*/
    t.start(); /*inicia el conteo de tiempo*/

    while(1) {/*inicia un nuevo ciclico*/
        if(GSM.readable()) { /*activada la lectura del puerto GSM*/
            char c = GSM.getc(); /*guarda en la variable c lo que lee en el puerto GSM*/
            sum = (c==resp[sum]) ? sum+1 : 0;// esta linea de C# sum se incrementa o se hace cero segun c
            if(sum == len)break;  //ya acabo se sale
        }
        if(t.read() > timeout) {  // time out chequea el tiempo minimo antes de salir perdiendo
            t.stop(); /*para la variable t*/
            t.reset();/*reinicia la variable t*/
            return -1; /*muestra que fallo el intento*/
        }
    } /*termina el ciclico de lectura del puerto GSM*/
    t.stop();                 // stop timer  antes de retornar
    t.reset();                    // clear timer
    while(GSM.readable()) {      // display the other thing..
        char c = GSM.getc(); /*guarda en la variable c lo que lee en el puerto GSM*/
    }

    return 0; /*todo sale bn*/
}
/* esta funcion de abajo es muy completa e util se encarga de enviar el comando y esperar la respuesta
si todo sale bien retorna un cero(herencia de las funciones contenedoras) que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int sendCmdAndWaitForResp(char *cmd, char *resp, int timeout) /*envia un comando de prueba y espera la respuesta de si efectivamente llegó*/
{
    sendCmd(cmd); /*envía comando cmd*/
    return waitForResp(resp,timeout); /*retorna el tiempo de espera*/
}
/* esta funcion de abajo chequea que el modem este vivo  envia AT y le contesta con OK y espera 2 segundos
*/
//***************************************************************************************
int powerCheck(void)// este comando se manda para verificar si el modem esta vivo o conectado
{
    return sendCmdAndWaitForResp("AT\r\n", "OK", 2);    
}
/* esta funcion de abajo chequea el estado de la sim card
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int checkSIMStatus(void) /*verifica el estado de la conexión con la SIM*/
{
    char gprsBuffer[30]; /*genera una cadena de 30 posiciones*/
    int count = 0; /*inicia el contador*/
    cleanBuffer(gprsBuffer,30); /*limpia el buffer*/
    while(count < 3) { /*condiciona el contador*/
        sendCmd("AT+CPIN?\r\n");  /*automaticamente envia el comando AT+CPIN*/
        readBuffer(gprsBuffer,30); /*lee el buffer*/
        if((NULL != strstr(gprsBuffer,"+CPIN: READY"))) { 
            break; /*si la longitud de la cadena no es nula sale del bucle*/
        }
        count++; /*amenta el contador*/
        wait(1); /*espera 1 segundo*/
    }

    if(count == 3) {
        return -1;   /*si count es igual a 3, el intento falló*/
    }
    return 0; /*si todo se cumple retorna el 0*/
}
/* esta funcion de abajo chequea la calidad de la señal
y si todo sale bien retorna con el valor de señal util o un -1 si no es aceptable, en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int checkSignalStrength(void) /*verifica el estado de la señal*/
{
    char gprsBuffer[100]; /*genera una cadena de 100 posiciones*/
    int index,count = 0; /*inicializa el contador y el index*/
    cleanBuffer(gprsBuffer,100); /*limpia el buffer*/
    while(count < 3) {  
        sendCmd("AT+CSQ\r\n"); /*si el contador es menor a 3 envía el comando AT+CSQ*/
        readBuffer(gprsBuffer,25); /*lee el buffer*/
        if(sscanf(gprsBuffer, "AT+CSQ$$$$+CSQ: %d", &index)>0) {
            break; /*si lee que la rta al comando AT+CSQ es mayor a ceso, sale del bucle*/
        }
        count++; /*aumenta el contador*/
        wait(1); /*espera 1 segundo*/
    }

    if(count == 3) {
        return -1;   /*si count es igual a 3, el intento falló*/
    }
    return index; /*finaliza el ciclo de verificación*/
}

/* esta funcion de abajo inicaliza el modem se compone de un grupo de subfunciones ya definidas previamente
primero chequea que este vivo
segundo chequea el estado de la simcard
tercero chequea la intencidad de señal celular
cuarto aplica la configuracion
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int init()
{
    if (0 != sendCmdAndWaitForResp("AT\r\n", "OK", 3)){  /*comprobamos la disponibilidad del dispositivo*/
        return -1;
        }
    if (0 != sendCmdAndWaitForResp("AT+CNMI=1,1\r\n", "OK", 3)){  /*actuva un evento cada vez que un sms ha llegado*/
        return -1;
        }
    if (0 != sendCmdAndWaitForResp("AT+CMGF=0\r\n", "OK", 3)){  /*comprobamos que el modem esté listo para operar en modo SMS texto*/
        return -1;
        }
    if (0 != sendCmdAndWaitForResp("AT+CBST=0,0,1\r\n", "OK", 3)){    /*comprueba queestn vbien ajustados los parámetros de funcionamiento del modem*/
        return -1;
        }
        LedVerde=0; /*prende led verde*/
        return 0;
        }
  
/* esta funcion de abajo intenta leer un mensaje de texto en formato PDU o HEX
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int readSMSpdu(char *message, int index)   /*funcion para leer los mensajes*/
{
    int i = 0;  /*inicializa i*/
    char gprsBuffer[100];  /*genera una cadena de 100 posiciones*/
    char *p,*s;
    GSM.printf("AT+CMGR=%d\r\n",index); /*recupera el mensaje del puerto GSM y lo imprime en la pantalla*/
    cleanBuffer(gprsBuffer,100); /*limpia el buffer*/
    readBuffer(gprsBuffer,100);  /*lee el buffer*/
    if(NULL == ( s = strstr(gprsBuffer,"+CMGR"))) { /*si el buffer esta vacío presenta un error*/
        return -1;
    }
    if(NULL != ( s = strstr(gprsBuffer,"+32"))) {  /*si el buffer está*/
        p = s + 6;
        while((*p != '$')&&(i < 5)) {
            message[i++] = *(p++);
        }
        message[i] = '\0'; /*finaliza la cadena*/
    }
    return 0; /*termina el ciclico*/
}
/* esta funcion de abajo borra mensajes SMS del modem
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int deleteSMS(int index)
{
    char cmd[32];  /*asigna una cadena de 32 posiciones*/
    snprintf(cmd,sizeof(cmd),"AT+CMGD=%d\r\n",index); /*imprime que el mensaje fue borrado*/
    sendCmd(cmd);  /*envía comando cmd*/
    return 0; /*termina la instrucción de borrado*/
}
//************************************************************************************
     
//RUTINA PRINCIPAL*******************************************************************************************
int main(void)
       {
       //configuramos los puertos seriales    
       GSM.baud(9600);//configura los baudios de la FRDMKL25Z en 9600
       GSM.format(8,Serial::None,1); //configura el formato de los datos de la UART     
       //apagamos los 3 leds
       LedVerde=1; /*inicia el led verde apagado*/
       LedRojo=1;  /*inicia el led rojo apagado*/
       LedAzul=1;  /*inicia el led azul apagado*/
       //quito el eco del modem
       GSM.printf("ATE0\r\n"); /*imprime en el puerto del GSM que el ATE0 elimina el eco del modém*/
       pc.printf("ATE0\r\n");  /*imprime en el pc que el ATE0 elimina el eco del modém*/
       for(i=0;i<6;i++){
          GSM.printf("AT+CMGD=%d\r\n",i); /*con el comando AT+CMGD se boran los mensajes*/
          wait(0.2);  /*espere 0.2 segundos*/
          }
       //cleanBuffer(buffer,10);
       //definicion de algunas variables
       lenpack=6;  //tamaño de "ALARMA"
       //Configuro el Modem, le doy solo 10 intentos si esos fracasan se bloquea y prende intermitente el led rojo
inicio:if(init()<0){ /*inicia el contador, suma hasta llegar a 10*/
       intentos++;
       if (intentos==10){goto loop1;} /*si llega a 10 intentos se reinicia el programa*/
       goto inicio;
       } 
       //cleanBuffer(buffer,50);
       //inicia el programa ciclico
       //esperar señales de alarma por boton1
       //se envia "Alarma1"
       //al telefono que envio mensaje antes
   
//*********************************************************************************************************************
while(1){ 
         if (button1.falling()) /*inicia con el boton 1*/
         { 
          wait(2); /*espera 2 segundos*/
           if (!button1) /*entra si se activa el boton 1*/
           {
           //inicia el envio de un sms    
           index=19;
           GSM.printf("AT+CMGS=%d\r\n",index);  /*envía un mensahe al numero seleccionado*/
           wait(0.2); /*espera 0.2 segundos*/
           GSM.printf("0011000A91"); 
           GSM.printf("%s",tel); /*imprime el numero de telefono*/
           GSM.printf("0000AA07417658DE0EC7");
           GSM.printf("\r\n");
           wait(0.2); /*espera 0.2 segundosj*/
           GSM.putc(0x1A); //el mensaje ya fue enviado con esto
           for(i=0;i<6;i++){ /*pone a parpadear el led verde*/
               LedVerde=1;
               wait(0.5);
               LedVerde=0;
               wait(0.5);
               }
           }
         }  
      


       //inicia la recepcion de un mensaje de texto
       if (GSM.readable()) { /*lee el puerto GSM*/
            readBuffer(buffer,100); /*lee el buffer*/
            pc.printf("%s\r\n",buffer); /*imprime ljo que encontro en el buffer*/
            for(i=0;i<5;i++)
            {
            resp[i]=buffer[i]; /*arma una cadena con lo que encontro en el buffer*/
            }  
             
            pc.printf("%s\r\n",resp); 
            if(strcmp("$$+CM",resp) == 0){  //COMPARA resp con "+CMTI"
                pc.printf("llego MSG\r\n"); /*avisa que llego el sms*/
                cleanBuffer(buffer,10);  /*limpia el buffer*/
                wait(0.5);/*espera medio segundo*/
                GSM.printf("AT+CMGL=0\r\n");//envio comando para leer mensaje
                pc.printf("AT+CMGL=0\r\n"); /*recupera todos los mensajes*/
                //if (GSM.readable()) {
                GSM.printf("AT+CMGD=0\r\n");     /*borra el mensaje */
                readBuffer(buffer,100);         /*lee el buffer*/
                pc.printf("%s\r\n",buffer);     /*imprime lo que lee anteriormente en el buffer*/
                wait(5); /*espera 5 segundos*/
                   //leer telefono
                for(i=0;i<10;i++){
                       tel[i]=buffer[i+40]; /*compone el numero de telefono*/
                       }
                pc.printf("%s-\r\n",tel);        /*imprime el numero de telefono*/
                //leer tamaño
                   for(i=0;i<2;i++){
                       tam[i]=buffer[i+68]; /*compone el tamaño de la trama*/
                   }
                   pc.printf("%s-\r\n",tam);        /*imprime el tamaño de la trama*/
                   //leer mensaje
                    for(i=0;i<14;i++){
                       msg[i]=buffer[i+70]; /*compone el mensaje*/
                   }
                   pc.printf("%s-\r\n",msg);   /*imprime el mensaje*/     
                   //decodificar mensaje
                   //comparar mensaje
                   if(strcmp("417658DE0EC700",msg) == 0){  //COMPARA resp con "417658DE0EC700" que es Alarma1
                   LedVerde=1; /*apagado el led verde*/
                   LedAzul=0; /*encendido el led azul*/
                   wait(15); /*espera 15 segundos*/
                   LedAzul=1; /*apaga el led azul*/
                   LedVerde=0; /*enciende el led verde*/
                   }
                   if(strcmp("417658DE0ECB00",msg) == 0){  //COMPARA resp con "417658DE0ECB00" que es Alarma2
                   LedVerde=1;  /*apagado el led verde*/
                   LedRojo=0; /*enciende el led rojo*/
                   wait(15);  /*espera 15 segundos*/
                   LedRojo=1; /*apaga el led rojo*/
                   LedVerde=0; /*enciende el led verde*/
                   }
                   
                   
                   //ejecurar orden  //ya se ejecuto
                   //08-D6379B1E569763  esto es Voltaje1
                   
                   
                   cleanBuffer(buffer,100); /*limpia el buffer*/
                               
                }
            }
               

        }


//**********************************************************************************************************************           
loop1: LedRojo=0;   /*inicia a titilar el led rojo, manteniendolo en 0.3 segundos encendido y 0.3 segundos apagado*/
       wait(0.3);
       LedRojo=1;
       wait(0.3);  
       goto loop1;
 
}