#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "DebouncedIn.h" 
#include "QEI.h"
 
//RtcCls rtc(p28, p27, p29, true);
Rtc_Ds1307 rtc(PTE0,PTE1); /*modulo I2C*/
 
Serial pc(USBTX, USBRX, "pc");
 
 
//Configuracion encoder
QEI wheel (PTA5, PTA4, NC, 100);
 
//Botones
DebouncedIn BotonENC(PTD5);  //Boton Encoder
 
DebouncedIn Boton2(PTE2);  //Boton para confirmar
 
//salida led
DigitalOut myled(LED1);
int dia=0,mes=0,anno=2015,hor=0,min=0,seg=0;
 
char buffer[128];
int readptr = 0;
int start=0;
int Config;
 
int main() {
    char c;
    Rtc_Ds1307::Time_rtc tm = {};
    
    while(1) {
        
        set_reloj:
       
        pc.printf("*************************************\n");
        pc.printf("* Menu for RTC Test :               *\n");
        pc.printf("* read  - reads the clock           *\n");
        pc.printf("* start - start the clock           *\n");
        pc.printf("* stop  - stop the clock            *\n");
        pc.printf("* write - write the clock           *\n");
        pc.printf("* ena   - enable Square wave output *\n");
        pc.printf("* dis   - disable square wave outp. *\n");
        pc.printf("*************************************\n");
        
        while( (c = pc.getc()) != '\n') {
            buffer[readptr++] = c;
        }
        buffer[readptr++] = 0;
        if (strncmp(buffer, "read", 4) == 0) {
            //  perform read
            pc.printf("Performing read operation\n");
            if (rtc.getTime(tm) ) {
                pc.printf("The current time is : %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
                pc.printf("The current date is : %s, %02d/%02d/%04d\n", rtc.weekdayToString(tm.wday), tm.mon, tm.date, tm.year);
            }
            
        }
        else if (strncmp(buffer, "write", 5) == 0) {
            //  perform write
            pc.printf("Enter the date (date 0..31)");
            pc.scanf("%d", &tm.date);
            pc.printf("Enter the date (month 1..12)");
            pc.scanf("%d", &tm.mon);
            pc.printf("Enter the date (year)");
            pc.scanf("%d", &tm.year);
            pc.printf("Enter the time (hours 0..23)");
            pc.scanf("%d", &tm.hour);
            pc.printf("Enter the time (minutes 0..59)");
            pc.scanf("%d", &tm.min);
            pc.printf("Enter the time (seconds 0..59)");
            pc.scanf("%d", &tm.sec);
            pc.printf("Performing write operation\n");
            
            while(pc.readable()) 
                pc.getc();
            rtc.setTime(tm, false, false);
        }
        else if (strncmp(buffer, "start", 5) == 0) {
            //  start
            readptr = 0;
            pc.printf("Dispositivo Iniciado\n");
            rtc.startClock();
            goto set_prev;
            
            
        }
        else if (strncmp(buffer, "stop", 4) == 0) {
            //  stop
            pc.printf("Performing stop operation\n");
            rtc.stopClock();
        }
        else if (strncmp(buffer, "ena", 3) == 0) {
            int rs;
            pc.printf("Please specify the frequency : [0 = 1Hz, 1 = 4.096kHz, 2 = 8.192kHz, 3 = 32.768kHz] ");
            scanf("%d", &rs);
            pc.printf("Enabling the output with %d option\n", rs);
            rtc.setSquareWaveOutput(true, (Rtc_Ds1307::SqwRateSelect_t)rs);
        }
        else if (strncmp(buffer, "dis", 3) == 0) {
            pc.printf("Disableing square wave output\n");
            rtc.setSquareWaveOutput(false, Rtc_Ds1307::RS1Hz);
        }
        else {
            pc.printf("syntax error\n");
        }
        readptr = 0;
        //pc.printf("\n\n\n");
        }


        set_prev:
        
        
        if (Config ==1){
            readptr = 0;
            goto set_reloj;
            }
        
                  
       
        
        set_alarma:
        pc.printf("******* Configuracion Alarma *******\n");
        
        
   /*inicia seleccion anno*/
     set_anno:
        while(1){
         
            anno=anno+wheel.getPulses();
            wheel.reset();
            
            /*restriccion del año--no se puede config alarma hacia el pasado*/
            
            if(anno>=2100){
                anno=2100;
            }
            else if (anno<=2015){
             anno=2015;
            }
     pc.printf("*Anno=%d\n ",anno);
    
    
    if(BotonENC.falling()){
        goto set_mes;
    }
    if(Boton2.falling()){
        goto set_comp;
    }       
            
    }
  /*termina seleccion anno*/
  
        /*seleccion mes*/
        set_mes:
        while(1){
         
            mes=mes+wheel.getPulses();
            wheel.reset();
            
            /*restricción mes--maximo 12 meses*/
     
            if(mes>=12){
                mes=12;}
            else if (mes<=0){
             mes=0;}
     pc.printf("*Mes=%d\n ",mes);
     
    if(BotonENC.falling()){
        goto set_dia;}
    if(Boton2.falling()){
        goto set_comp;}
            
    }
   /*termina seleccion mes*/
   
     /*inicia dia*/   
        set_dia:
        while(1){
         
            dia=dia+wheel.getPulses();
            wheel.reset();
          /*restricción al numero de dias--maximo 31--*/
            if(dia>=31){
                dia=31;}
            else if (dia<=0){
             dia=0;}
             
     pc.printf("*Dia=%d\n ",dia);
    
    if(BotonENC.falling()){
        goto set_hor;
        }
    if(Boton2.falling()){
        goto set_comp;
    }
    }
        /*termine dia*/
  /*inicia seleccion hora*/
    set_hor:
        while(1){
         
            hor=hor+wheel.getPulses();
            wheel.reset();
            
            /*restriccion de la hora--no puede ser mayor de 23*/
     
            if(hor>=23){
                hor=23;
            }
            else if (hor<=0){
             hor=0;
            }
     pc.printf("*Hora=%d\n ",hor);
    
    
    if(BotonENC.falling()){
        goto set_min;
    }
    if(Boton2.falling()){
        goto set_comp;
    }
    
               
    }
    /*finaliza la seleccion de la hora*/
    
    /*seleccion min*/
     set_min:
        while(1){
         
            min=min+wheel.getPulses();
            wheel.reset();
            
            /*restriccion de la hora--no puede ser mayor a 59*/
     
            if(min>=59){
                min=59;
            }
            else if (min<=0){
             min=0;
            }
     pc.printf("*Min=%d\n ",min);
    
    if(BotonENC.falling()){
        goto set_seg;
    }
    if(Boton2.falling()){
        goto set_comp;
    }
    
    }
    /*termina la seleccion de los minutos*/
    
    /*seleccionar segundos*/
    set_seg:
        while(1){
         
            seg=seg+wheel.getPulses();
            wheel.reset();
            
            /*restriccion de los segundos--no puede ser mas de 59*/
            
            if(seg>=59){
                seg=59;
            }
            else if (seg<=0){
             seg=0;
            }
     pc.printf("*Seg=%d\n ",seg);
    
    if(BotonENC.falling()){
        goto set_anno;
    }
    if(Boton2.falling()){
        goto set_comp;
    }
           
            
    }
    /*termina la seleccion de los segundos*/
    
    set_comp:
    
    pc.printf("Alarma configurada para: \n");
    pc.printf(" Anno=%d\n ",anno); /* imprime el año */
    pc.printf(" Mes=%d\n ",mes);   /* imprime el mes */
    pc.printf(" Dia=%d\n ",dia);   /* imprime el dia */
    pc.printf(" Hora=%d\n ",hor);  /* imprime la hora */
    pc.printf(" Min=%d\n ",min);   /* imprime los minutos */
    pc.printf(" Seg=%d\n ",seg);   /* imprime los segundos */
    wait(3);
    
    /*comparamos la alarma programada con la hora del reloj, si coincide
    prende el led*/
    while(1){
       rtc.getTime(tm);
       pc.printf("The current time is : %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
       
    if(tm.hour>=hor && tm.min>=min &&tm.sec>=seg && tm.mon>=mes && tm.date>=dia && tm.year>=anno){
        myled=0;
    }
    else {
        myled=1;
        }
        wait(1);
    }
     ////   
     
    }