// dimmed kitt LED blinking
//   the question was how to enable dimming on multiple digital led the same time.
//   it could be done simpler with math/sin, yet it I found it more fun
#include "mbed.h"
#include "math.h"

PwmOut led[4] = { LED1, LED2, LED3, LED4 };

float DimVal( int idx, float f ) {
    return (sin(f + float(idx)*1.6) + 1.0) / 2.0;   // transform value from -1.0 .. 1.0 to 0.0 .. 1.0
}

int main() {
    while (1) {
         for (float f = 0.0f; f < 6.3; f += 0.1f) {
            led[0] = DimVal( 0, f );
            led[1] = DimVal( 1, f );
            led[2] = DimVal( 2, f );
            led[3] = DimVal( 3, f );
            wait_ms(10);
        }
    }
}
