// dimmed kitt LED blinking
//   the question was how to enable dimming on multiple digital led the same time.
//   it could be done simpler with math/sin, yet it I found it more fun
#include "mbed.h"

DigitalOut led[4] = { LED1, LED2, LED3, LED4 };
int  dim[4] = { 1, 1, 1, 1 };  // 1:always on N: darker, I use 1..100

void Dim( ) {
   for (long int i=0; i < 10000; ++i) {          // repeat a few times just to slow down
      for (int i2=0; i2<4; ++i2) {
         led[i2] = (((i%dim[i2])==0) ? 1 : 0);
      }
   }
}

void Update1( int i ) {      // i:1..99
      dim[0] = i;
      dim[1] = (i-33)%200 + 1;
      dim[2] = (i-66)%200 + 1;
      dim[3] = i-100; // could be (i-100)%200 + 1;
}

void Update2( int i ) {      // i:1..99
      dim[0] = 100-i;
      dim[1] = (i-66)%200 + 1;
      dim[2] = (i-33)%200 + 1;
      dim[3] = i;
}

/* phase-shift the LED dimming 1..100 positive, 101..199 going back
that work, but the above is easier to understand
int Rate( int i ) {                 // calculate dim rate, convert 1..200 to 1..100..1
    return (i<100) ? i : (200-i);
}
void Update( int i ) {
      dim[0] = Rate( i%200 + 1 );
      dim[1] = Rate( (i+(i<100?-33:33))%200 + 1);
      dim[2] = Rate( (i+(i<100?-66:66))%200 + 1);
      dim[3] = Rate( (i+100)%200 + 1);
}
*/

int main() {
    while(1) {
        for (int i = 1; i <100; ++i )        // to
        {
            Update1( i );
            Dim( );
        }
        for (long int i = 1; i <100; ++i )   // and back
        {
            Update2( i );
            Dim( );
        }
    }
}
