#include "mbed.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

void blink( DigitalOut &arg_led, double arg_dur = 0.1 ) {
    arg_led = 1;
    wait( arg_dur );
    arg_led = 0;
    wait( 0.01 );
}

void dimblink( DigitalOut &arg_led ) {
       for (float f = 0.01; f < 1; f += 0.02 ) {
            blink( arg_led, f / 100.0 );
       }
       for (float f = 1; f >0; f -= 0.02 ) {
            blink( arg_led, f / 100.0 );
       }
}

int main() {
    while(1) {
        dimblink( led1 );
        dimblink( led2 );
        dimblink( led3 );
        dimblink( led4 );
        dimblink( led3 );
        dimblink( led2 );
    }
}
