#include "mbed.h"
#include <cstring>
#include <cstdio>

Timer timer;            // az időzítő, ami a mérés időpontját biztosítja
Ticker meres;           // egy időzített feladat, ami végrehajta a mérést
AnalogIn an(p15);       // az analóg pin
Serial rn42(p9,p10);    // a bluetooth serial lábai
Serial pc(USBTX, USBRX);// a számítógépes serial kapcsolat
DigitalOut myled(LED1);
char c;                 // egy karakter, amit kiolvas a serialread részben
char buf[250];          // a karaktersorozat gyűjtője
char p = 0;             // a gyűjtő karaktersorozat aktív elemének az indexe
float szorzo = 3.3;     // azaz [V]-ban kapom vissza az értékeket
char elinditva = 0;     // 0 ha nem folyik mérés; 1 ha igen
float d_ido = 0.005;     // két mérés között eltelt idő

void mfunc() {
    // mért adat bluetoothra küldése
    rn42.printf("%d %f\n",timer.read_ms(), an*szorzo);
}

void parancs(char cmd[]){
    pc.printf("\nparancs: %s\n",cmd);
    if (strcmp(cmd,"start") == 0 && elinditva == 0){
      // azaz el akarom indítani a mérést.
      timer.start();
      meres.attach(&mfunc, d_ido);
      elinditva = 1;
    } else 
    if (strcmp(cmd,"stop") == 0 && elinditva == 1){
      // azaz meg akarom állítani a mérést.
      meres.detach();
      timer.stop();
      timer.reset();
      elinditva = 0;
    } else
    if (sscanf(cmd,"set%*[ ]time%*[ ]%f",&d_ido)==1){
      // azaz beállítom a mérések közötti időt
    } else
    if (sscanf(cmd,"set%*[ ]scale%*[ ]%f",&szorzo)==1){
      // azaz beállítom a mérés szorzóját
    }
    
}

int main() {
    rn42.baud(115200);
    pc.baud(460800);

    // biztosítom, hogy kapjon bejövő adatot!
    while (1) {
        while (rn42.readable()) {
            c = rn42.getc();
            pc.putc(c);
            if (c!='\n') {
                buf[p++]=c;
            } else {
                pc.printf("%s\n",buf);
                parancs(buf);
                // visszaállítás a kezdeti értékre
                memset(buf, 0, 100);
                p=0;
            }
        }
    }
}
