#include "mbed.h"

#ifndef MBED_GPS_H

#define MBED_GPS_H

/**  A GPS interface for reading from a Globalsat EM-406 GPS Module */
class GPS {
public:
    /* Create the GPS interface, connected to the specified serial port*/
     GPS(PinName tx, PinName rx);
     /* 
     Sample the incoming GPS data, returning whether there is a lock
     @return 1 if there was a lock when the sample was taken (and therefore .longitude and .latitude are valid), else 0
     */
    int sample();
    float old_sz,old_h,tav,vit,start,delta_t;
    struct data {
     int ora,perc,masodperc;
     char flag;
     float szel;
     char szb;
     float hossz;
     char hb;
     float sebesseg;
     float magassag;
     int ev,honap,nap;
    } poz;
    float tavolsag(float h1,float sz1,float h2,float sz2);
    
private:
    void getline();
    void nincs_adat();
       
    Serial _gps;
    char msg[256];

};

#endif
