#include "GPS.h"

#define pi 3.14159265359
#define r 6367.444657

GPS::GPS(PinName tx,PinName rx):_gps(tx,rx)
{
 _gps.baud(4800);
}

int GPS::sample()
{
 float d1,d2;
  
 while(1) 
 {
  getline();
  if(sscanf(msg,"GPGGA,%2d%2d%2d,%f,%c,%f,%c,%c,%f,%f,%f",
                &poz.ora,&poz.perc,&poz.masodperc,
                &poz.szel,&poz.szb,
                &poz.hossz,&poz.hb,
                &poz.flag,
                &d1,&d2,
                &poz.magassag)>=1) 
  {
   printf("%f %f\n\r",poz.szel,poz.hossz);
   //delta_t=(clock()-start)/CLOCKS_PER_SEC;
   //start=clock();
   //if (delta_t==0) delta_t=1.0;
   //if(poz.flag=='1') nincs_adat();
   //tav=tavolsag(poz.szel,poz.hossz,old_sz,old_h);
   //vit=tav/delta_t*3.6;
   //poz_old=poz_new;
   return 1;
  }
  /*if(sscanf(msg,"GPRMC,%2d%2d%2d,%c,%f,%c,%f,%c,%f,%f,%2d%2d%2d",
                &poz.ora,&poz.perc,&poz.masodperc,
                &poz.flag,
                &poz.szel,&poz.szb,
                &poz.hossz,&poz.hb,
                &poz.sebesseg,
                &d1,
                &poz.nap,&poz.honap,&poz.ev)>=1) 
  {
   delta_t=(clock()-start)/CLOCKS_PER_SEC;
   start=clock();
   if (delta_t==0) delta_t=1.0;
   if(poz.flag=='V') nincs_adat();
   //tav=tavolsag(poz_new.szel,poz_new.hossz,poz_old.szel,poz_old.hossz);
   //vit=tav/delta_t*3.6;
   //poz_old=poz_new;
   return 1;
  }*/
 }
}

void GPS::nincs_adat()
{
 poz.hossz=0.0;
 poz.hb='?';
 poz.szel=0.0;
 poz.szb='?';
 poz.sebesseg=0.0;
 poz.magassag=0.0;
}

float GPS::tavolsag(float szel1,float hossz1,float szel2,float hossz2)
{
 float x1,y1,z1,x2,y2,z2;
 float h1,h2,sz1,sz2;

 sz1=(int)(szel1/100)+(szel1-100*(int)(szel1/100))/60;
 h1=(int)(hossz1/100)+(hossz1-100*(int)(hossz1/100))/60;
 sz2=(int)(szel2/100)+(szel2-100*(int)(szel2/100))/60;
 h2=(int)(hossz2/100)+(hossz2-100*(int)(hossz2/100))/60;
 x1=r*cos(sz1)*sin(h1);
 y1=r*cos(sz1)*cos(h1);
 z1=r*sin(sz1);
 x2=r*cos(sz2)*sin(h2);
 y2=r*cos(sz2)*cos(h2);
 z2=r*sin(sz2);
 return sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1)+(z2-z1)*(z2-z1))*1000;
}

void GPS::getline()
{
 while(_gps.getc() != '$');    // wait for the start of a line
 for(int i=0;i<256;i++) 
 {
  msg[i]=_gps.getc();
  if(msg[i]=='\r') 
  {
   msg[i]=0;
   return;
  }
 }
 error("Tul hosszu szoveg !");
}
