/*--------------------------------------------------------------
/   7sed LED out sample
--------------------------------------------------------------*/
#include "mbed.h"

// 7seg LED - a, b, c, d, e, f, g, DP - [port assined]
BusOut ledX(p25, p24, p14, p13, p12, p27, p26, p15);    // 2digit
BusOut ledY(p22, p21, p19, p17, p16, p23, p18, p20);    // 1digit

// mbed LED
BusOut mled(LED4, LED3, LED2, LED1);

int main() {
    // 7seg LED bit pattern -  Dgfe dcba     
    const int n0 = 0x3F;    // 0011 1111
    const int n1 = 0x06;    // 0000 0110
    const int n2 = 0x5B;    // 0101 1011
    const int n3 = 0x4F;    // 0100 1111
    const int n4 = 0x66;    // 0110 0110
    const int n5 = 0x6D;    // 0110 1101
    const int n6 = 0x7D;    // 0111 1101
    const int n7 = 0x07;    // 0000 0111
    const int n8 = 0x7F;    // 0111 1111
    const int n9 = 0x6F;    // 0110 1111

    // convert: count -> 7seg number
    const int nX[] = {n0, n1, n2, n3, n4, n5, n6, n7, n8, n9};
    
    int nCntX = 0;          // 7seg LED counter
    int nCntY = 0;          // mbed LED counter
    
    // port init
    ledX = ~0;
    ledY = ~0;
    mled = 0;
    
    while(1) {
        // 7seg LED count up
        ledX = ~nX[nCntX / 10];
        ledY = ~nX[nCntX % 10];        
        nCntX++;
        
        // 7seg LED limit count 99
        if (100 == nCntX) {
            nCntX = 0;
            nCntY++;
            
            // mled LED count up
            mled = 0x0F & nCntY;
        }
        
        wait(0.1);
    }
}
