#include "MPU9150_raw.h"

// I2Cdev and MPU9150 must be installed as libraries, or else the .cpp/.h files
// for both classes must be in the include path of your project
#include "I2Cdev.h"
#include "MPU9150.h"
#include "helper_3dmath.h"
#include "ArduinoSerial.h"

namespace MPU9150raw {
// class default I2C address is 0x68
// specific I2C addresses may be passed as a parameter here
// AD0 low = 0x68 (default for InvenSense evaluation board)
// AD0 high = 0x69
MPU9150 accelGyroMag;

int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;

DigitalOut led1(LED1);
ArduinoSerial arduinoSerial;

void setup() {
    // initialize Serial communication
    // (38400 chosen because it works as well at 8MHz as it does at 16MHz, but
    // it's really up to you depending on your project)
    arduinoSerial.begin(115200);

    // initialize device
    arduinoSerial.println("Initializing I2C devices...");
    accelGyroMag.initialize();

    // verify connection
    arduinoSerial.println("Testing device connections...");
    arduinoSerial.println(accelGyroMag.testConnection() ? "MPU9150 connection successful" : "MPU9150 connection failed");
}

void loop() {
    // read raw accel/gyro/mag measurements from device
    accelGyroMag.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz);

    // these methods (and a few others) are also available
    //accelGyroMag.getAcceleration(&ax, &ay, &az);
    //accelGyroMag.getRotation(&gx, &gy, &gz);

    // display tab-separated accel/gyro/mag x/y/z values
    arduinoSerial.print("a/g/m:\t");
    arduinoSerial.print(ax); arduinoSerial.print("\t");
    arduinoSerial.print(ay); arduinoSerial.print("\t");
    arduinoSerial.print(az); arduinoSerial.print("\t");
    arduinoSerial.print(gx); arduinoSerial.print("\t");
    arduinoSerial.print(gy); arduinoSerial.print("\t");
    arduinoSerial.print(gz); arduinoSerial.print("\t");
    arduinoSerial.print(int(mx)*int(mx)); arduinoSerial.print("\t");
    arduinoSerial.print(int(my)*int(my)); arduinoSerial.print("\t");
    arduinoSerial.print(int(mz)*int(mz)); arduinoSerial.print("\t | ");

    const float N = 256;
    float mag = mx*mx/N + my*my/N + mz*mz/N;

    arduinoSerial.print(mag); arduinoSerial.print("\t");
    for (int i=0; i<mag; i+=100000)
        arduinoSerial.print("*");
    arduinoSerial.print("\r\n");

    // blink LED to indicate activity
    if( led1 == 0 ) led1 = 0;
    else led1 = 1;
    wait_ms(50);
}

};