#include "MPU6050_raw.h"

// I2Cdev and MPU6050 must be installed as libraries, or else the .cpp/.h files
// for both classes must be in the include path of your project
#include "I2Cdev.h"
#include "MPU6050.h"

#include "ArduinoSerial.h"

// uncomment "OUTPUT_READABLE_ACCELGYRO" if you want to see a tab-separated
// list of the accel X/Y/Z and then gyro X/Y/Z values in decimal. Easy to read,
// not so easy to parse, and slow(er) over UART.
#define OUTPUT_READABLE_ACCELGYRO

// uncomment "OUTPUT_BINARY_ACCELGYRO" to send all 6 axes of data as 16-bit
// binary, one right after the other. This is very fast (as fast as possible
// without compression or data loss), and easy to parse, but impossible to read
// for a human.
//#define OUTPUT_BINARY_ACCELGYRO

namespace MPU6050raw {
// class default I2C address is 0x68
// specific I2C addresses may be passed as a parameter here
// AD0 low = 0x68 (default for InvenSense evaluation board)
// AD0 high = 0x69
MPU6050 accelgyro;
//MPU6050 accelgyro(0x69); // <-- use for AD0 high

int16_t ax, ay, az;
int16_t gx, gy, gz;

DigitalOut led1(LED1);
ArduinoSerial arduinoSerial;

void setup() {
    // initialize arduinoSerial communication
    // (38400 chosen because it works as well at 8MHz as it does at 16MHz, but
    // it's really up to you depending on your project)
    arduinoSerial.begin(38400);

    // initialize device
    arduinoSerial.println("Initializing I2C devices...");
    accelgyro.initialize();

    // verify connection
    arduinoSerial.println("Testing device connections...");
    arduinoSerial.println(accelgyro.testConnection() ? "MPU6050 connection successful" : "MPU6050 connection failed");

    // use the code below to change accel/gyro offset values
    /*
    arduinoSerial.println("Updating internal sensor offsets...");
    // -76  -2359   1688    0   0   0
    arduinoSerial.print(accelgyro.getXAccelOffset()); arduinoSerial.print("\t"); // -76
    arduinoSerial.print(accelgyro.getYAccelOffset()); arduinoSerial.print("\t"); // -2359
    arduinoSerial.print(accelgyro.getZAccelOffset()); arduinoSerial.print("\t"); // 1688
    arduinoSerial.print(accelgyro.getXGyroOffset()); arduinoSerial.print("\t"); // 0
    arduinoSerial.print(accelgyro.getYGyroOffset()); arduinoSerial.print("\t"); // 0
    arduinoSerial.print(accelgyro.getZGyroOffset()); arduinoSerial.print("\t"); // 0
    arduinoSerial.print("\n");
    accelgyro.setXGyroOffset(220);
    accelgyro.setYGyroOffset(76);
    accelgyro.setZGyroOffset(-85);
    arduinoSerial.print(accelgyro.getXAccelOffset()); arduinoSerial.print("\t"); // -76
    arduinoSerial.print(accelgyro.getYAccelOffset()); arduinoSerial.print("\t"); // -2359
    arduinoSerial.print(accelgyro.getZAccelOffset()); arduinoSerial.print("\t"); // 1688
    arduinoSerial.print(accelgyro.getXGyroOffset()); arduinoSerial.print("\t"); // 0
    arduinoSerial.print(accelgyro.getYGyroOffset()); arduinoSerial.print("\t"); // 0
    arduinoSerial.print(accelgyro.getZGyroOffset()); arduinoSerial.print("\t"); // 0
    arduinoSerial.print("\n");
    */
}

void loop() {
    // read raw accel/gyro measurements from device
    accelgyro.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);

    // these methods (and a few others) are also available
    //accelgyro.getAcceleration(&ax, &ay, &az);
    //accelgyro.getRotation(&gx, &gy, &gz);

    #ifdef OUTPUT_READABLE_ACCELGYRO
        // display tab-separated accel/gyro x/y/z values
        arduinoSerial.print("a/g:\t");
        arduinoSerial.print(ax); arduinoSerial.print("\t");
        arduinoSerial.print(ay); arduinoSerial.print("\t");
        arduinoSerial.print(az); arduinoSerial.print("\t");
        arduinoSerial.print(gx); arduinoSerial.print("\t");
        arduinoSerial.print(gy); arduinoSerial.print("\t");
        arduinoSerial.println(gz);
    #endif

    #ifdef OUTPUT_BINARY_ACCELGYRO
        arduinoSerial.write((uint8_t)(ax >> 8)); arduinoSerial.write((uint8_t)(ax & 0xFF));
        arduinoSerial.write((uint8_t)(ay >> 8)); arduinoSerial.write((uint8_t)(ay & 0xFF));
        arduinoSerial.write((uint8_t)(az >> 8)); arduinoSerial.write((uint8_t)(az & 0xFF));
        arduinoSerial.write((uint8_t)(gx >> 8)); arduinoSerial.write((uint8_t)(gx & 0xFF));
        arduinoSerial.write((uint8_t)(gy >> 8)); arduinoSerial.write((uint8_t)(gy & 0xFF));
        arduinoSerial.write((uint8_t)(gz >> 8)); arduinoSerial.write((uint8_t)(gz & 0xFF));
    #endif

    // blink LED to indicate activity
    if( led1 == 0 ) led1 = 0;
    else led1 = 1;
}

};