#ifndef CONTROLOR_H_2013_02_02_
#define CONTROLOR_H_2013_02_02_

#include "mbed.h"
#include <string>
#include <fstream>

#include "Motion.h"
#include "OfflineMotion.h"
#include "OnlineMotion.h"
#include "CPG.h"

#include "Console.h"
//#include "PWM.h"
#include "Adafruit_PWMServoDriver.h"
#include "RS300.h"

#include "CSV.h"
#include "readMotion.h"

class Controlor
{
  public:
    Controlor(uint16_t* data);
    ~Controlor();
    
  public:
    void control();
    
  private:
    void home();
    void read(const string& filename, uint16_t* data);
    void set(uint16_t* data);
    bool checkid(int id);
    
  public:
    void setmotion(const int id);
    void play();
  
  private:
    uint16_t*** motions;
    int motion_size;
    int* pose_size;
    int servo_size;
    
    OfflineMotion* offline;
    OnlineMotion* online;
    CPG* cpg;
    Motion* motion;
    //std::ofstream log;
    int mode;
    
  private:
    bool playing;
    bool attached;
    Console* comu;
    //PWM* pwm;
    Adafruit_PWMServoDriver* pwm;
    RS300* rs300;
};

#endif
