#ifndef PWM_H_2012_08_28_
#define PWM_H_2012_08_28_

#include "LPC17xx.h"
#include "mbed.h"

const uint32_t SRV_PERIOD = 2500 - 1;//
const uint32_t SRV_MAX_DUTY = 2100 - 1;//
const uint32_t SRV_MIN_DUTY = 900 - 1;//

const uint8_t SRV_IDX_SHIFT = 3;//
const uint8_t SRV_IDX_NUM = 1 << SRV_IDX_SHIFT;//
const uint8_t SRV_IDX_MASK = SRV_IDX_NUM - 1;//
const uint8_t SRV_BANK_NUM = 3;//
const uint8_t SRV_CH_NUM = SRV_IDX_NUM * SRV_BANK_NUM;//

const uint32_t SRV_PWMTable[SRV_BANK_NUM][SRV_IDX_NUM] = {
    {0,SRV_PERIOD,0,SRV_PERIOD,0,SRV_PERIOD,0,SRV_PERIOD},
    {0,0,SRV_PERIOD,SRV_PERIOD,0,0,SRV_PERIOD,SRV_PERIOD},
    {0,0,0,0,SRV_PERIOD,SRV_PERIOD,SRV_PERIOD,SRV_PERIOD}
    };

class PWM {
  public:
    PWM();
  public:
    void InitPWM();
    void setDuty(uint8_t ch, uint32_t duty);
  public:
    static volatile uint8_t SRV_Idx;
    static volatile uint32_t SRV_dutyTable[SRV_BANK_NUM][SRV_IDX_NUM];
};

#ifdef __cplusplus
extern "C" {
    void PWM1_IRQHandler();
}
#endif

#endif  //PWM_H_2012_08_28_