#include "mbed.h"
#include "Adafruit_PWMServoDriver.h"

Adafruit_PWMServoDriver pwm(p9, p10);

void setServoPulse(uint8_t n, float pulse) {
    float pulselength = 10000;   // 10,000 us per second
    pulse = 4094 * pulse / pulselength;
    pwm.setPWM(n, 0, pulse);
}

void initServoDriver() {
    pwm.begin();
    //pwm.setPWMFreq(100);  //This dosen't work well because of uncertain clock speed. Use setPrescale().
    pwm.setPrescale(64);    //This value is decided for 10ms interval.
    pwm.setI2Cfreq(400000); //400kHz
}

int main() {
    //pwm.i2c_probe();
    initServoDriver();
    setServoPulse(0, 1000);
    
    while(1);
}
