#include "mbed.h"
#include "SSD1306_mini.h"

#define g2 5102  //G
#define gis2 4808 //G#
#define a2  4545 //A
#define ais2 4274 //A#
#define h2  4065 //B
#define c3  3817 //C octave3
#define cis3 3597 //C#
#define d3  3401 //D
#define dis3 3205//D#
#define e3  3030 //E
#define f3  2857 //F
#define fis3 2703 //F#
#define g3  2551 //G
#define gis3 2404 //G#
#define a3  2273 //A
#define ais3 2146 //A#
#define h3  2024 //B
#define c4  1908 //C octave4
#define cis4 1805 //C#
#define d4  1701 //D
#define dis4 1608//D#
#define e4  1515 //E
#define f4  1433 //F
#define fis4 1351 //F#
#define g4  1276 //G
#define gis4 1205 //G#
#define a4  1136 //A
#define ais4 1073 //A#
#define h4  1010 //B
#define c5  956 //C octave5
#define cis5 903 //C#
#define d5  852 //D
#define dis5 804//D#
#define e5  759 //E
#define f5  715 //F
#define fis5 675 //F#
#define g5  638 //G
#define gis5 602 //G#
#define a5  568 //A
#define ais5 536 //A#
#define h5  506 //B
//-----------------------

#define MENU  0
#define STOPWATCH  1
#define TIMER  2
#define RUNTIMER  3
#define START  "START"
#define RESET  "RESET"
#define STOP " STOP"
#define NEXT " NEXT"
#define BACK "BACK "
#define ROLL "ROLL "
#define SET "  SET"
#define EMPTY "     "
#define Y_SOLO  5

DigitalIn button1(PA_5, PullUp);
DigitalIn button2(PA_6, PullUp);
DigitalOut myled(PA_7);
DigitalOut rele(PA_3);
PwmOut buzzer(PB_1);
I2C i2c = I2C(PA_10, PA_9);
SSD1306_mini_i2c oled = SSD1306_mini_i2c(i2c, PA_4);

Timer t;
Timer tTimer;
Timer t1;
Timer t2;
Ticker alarm;

bool but1Action;
bool but2Action;
bool updatedBuff;
bool needClear;
char *leftButText;
char *rightButText;
int16_t melodyInit[] = {
    g4, g4, d5, c5, ais4,
    a4, a4, a4, c5, ais4, a4,
    g4, g4, ais5, a5, ais5, a5, ais5,
    g4
};
uint8_t durationInit[] = {
    250,125,125,250,250,
    250,125,125,250,125,125,
    250,125,125,125,125,125,125,
    250
};
int16_t melody[] = {
    g4, d5, g4, d5, dis5, d5, g4, d5,   //
    g4, d5, g4, d5, dis5, d5, g4, d5,   //
    g3, d5, g4, d5, dis5, d5, g4, d5,   //
    ais2, d5, g4, d5, dis5, d5, g4, d5, //
    f3, d5, g4, d5, dis5, d5, g4, d5,   //
    c3, d5, g4, d5, dis5, d5, g4, d5,   //
    c3, d5, g4, d5, dis5, d5, d3, d3,   //
    ais3, d3, d3, d3, d3, d3, a3, d3,
    ais3, f3, ais2, f3, ais2, f3, c4, f3,
    a3, c3, c3, c3, c3, c3, c3, c3,
    g3, g2, c3, g2, c3, g2, a3, g2,
    d4, d4, d4, d4, dis5, d5, g4, d5
};
int8_t indexTone = 0;


void playTone(int16_t halfPeriod, uint8_t duration){
    buzzer.period_us(halfPeriod * 2);
    buzzer.write(0.50f);    
    wait_ms(duration);
    buzzer.write(0.00f);    
}

void readButtons(){
    if(button1 == 0 && t1.read_ms() > 150){
        t1.stop();
        t1.reset();
        t1.start();
        but1Action = true;
        playTone(c4, 20);
//        myled = !myled;     
    } 
    if(button2 == 0 && t2.read_ms() > 150){
        t2.stop();
        t2.reset();
        t2.start();
        but2Action = true;
        playTone(e5, 20);
//        myled = !myled;     
    }  
}

void alarmSound(){ 
    uint64_t period = melody[indexTone]*2;
    indexTone = indexTone +1;
    if(indexTone ==  96) indexTone = 0;
    buzzer.write(0.00f);
    wait_ms(10);     
    buzzer.period_us(period);
    buzzer.write(0.50f);     
}

void updateButsMeaning(){
    oled.setTextSize(1);
    oled.setTextColor(WHITE, BLACK);
    oled.writeString(0, 25, leftButText, &updatedBuff);
    oled.writeString(98, 25, rightButText, &updatedBuff);
    oled.setTextSize(2);        
}

void setButsMeaning(char *leftText, char *rightText){
    rightButText = rightText;
    leftButText = leftText;        
}

void updateMenu(bool top){
    if(top){
        oled.setTextColor(BLACK, WHITE);        
        oled.writeString(10, 0, "STOPWATCH", &updatedBuff);
        oled.setTextColor(WHITE, BLACK);
        oled.writeString(36, 16, "TIMER", &updatedBuff);               
    }else{
        oled.setTextColor(BLACK, WHITE);
        oled.writeString(36, 16, "TIMER", &updatedBuff);
        oled.setTextColor(WHITE, BLACK);
        oled.writeString(10, 0, "STOPWATCH", &updatedBuff);        
    }    
}

void screenMenu(int8_t *state, int8_t *screen){
    switch(*state){
    case -1:
        setButsMeaning(EMPTY, EMPTY);
        updateMenu(true);
        *state = 0;
        break;
    case 0:
        if(but2Action){
             needClear = true;
             *screen = STOPWATCH;
             *state = -1;       
        }
        else if(but1Action){
            updateMenu(false);
            *state = 1;
        }        
        break;
    case 1:
        if(but2Action){
             needClear = true;
             *screen = TIMER;
             *state = -2;       
        }
        else if(but1Action){
            updateMenu(true); 
            *state = 0;
        } 
        break;
    }     
}

void screenStopwatch(int8_t *state, int8_t *screen){
    int8_t currentState = *state; 
    switch(*state){
    case -1:    //init
        setButsMeaning(BACK, START);
        *state = 0;
        break;
    case 0:
        if(but1Action){
            *state = -1;
            needClear = true;
            *screen = MENU;
        }    
        else if(but2Action){
            t.start();
            *state = 1;
            setButsMeaning(EMPTY, STOP);  
        }        
        break;
    case 1: 
        if(but2Action){
            t.stop();
            *state = 2;
            setButsMeaning(RESET, START);  
        }          
        break;
    case 2:
        if(but1Action){
            t.reset();            
            *state = 0;
            setButsMeaning(BACK, START);
        }    
        else if(but2Action){
            t.start();
            *state = 1;
            setButsMeaning(EMPTY, STOP);  
        }            
        break;
    }
    if(but1Action || but2Action || *state == 1 || currentState == -1){         
        int time_ms = t.read_ms();
        int time_sec = time_ms / 1000;
        int time_min = time_sec / 60;
        char buf[10];
        sprintf(buf, "%02d:%02d.%03d", time_min, time_sec-time_min*60, time_ms-time_sec*1000);
        oled.writeString(10, Y_SOLO, buf, &updatedBuff);
    }
}

void setNumber(int8_t *state, int8_t *digitsTimer, int8_t maxDigit){
    if(but1Action){ 
        digitsTimer[*state]++;
        if(digitsTimer[*state] == maxDigit) digitsTimer[*state] = 0; 
    }
    else if(but2Action) *state = *state + 1;    
}

void screenTimer(int8_t *state, int8_t *screen, int8_t *digitsTimer){
    int8_t currentState = *state;
    
    switch(*state){
    case -2:    //init
        setButsMeaning(BACK, SET);
        *state = *state + 1;
        break;
    case -1:
        if(but1Action){
            *screen = MENU;
        }    
        else if(but2Action){
            *state = *state + 1;
            setButsMeaning(ROLL, NEXT);
        }
        break;
    case 0:
        setNumber(state, digitsTimer, 10);
        break;
    case 1:
        setNumber(state, digitsTimer, 10);
        break;
    case 2:
        setNumber(state, digitsTimer, 6);
        break;
    case 3:
        setNumber(state, digitsTimer, 10);
        if(but2Action) setButsMeaning(BACK, START);
        break;
    case 4:
        if(but1Action){
            *state = -1;
            setButsMeaning(BACK, SET);
        }
        else if(but2Action){
            *state = -1;
            *screen = RUNTIMER;   
        }    
        break;
    case 5:     //init form TimerRun
        *state = 4;
    }
    if(but1Action || but2Action || currentState == -2 || currentState == 5){
        oled.setTextCursor(35, Y_SOLO);
        for(uint8_t i = 0; i < 4; i++){
            if(i == *state) oled.setTextColor(BLACK, WHITE);
            else oled.setTextColor(WHITE, BLACK);
            char buf[2];
            sprintf(buf, "%d", digitsTimer[i]);              
            oled.writeString(-1, -1, buf, &updatedBuff);
            if(i == 1){
                oled.setTextColor(WHITE, BLACK);
                oled.writeString(-1, -1, ":", &updatedBuff);
            }    
        }
        oled.setTextColor(WHITE, BLACK);
    } 
}

void blinkAlarm(int time, int8_t *state){
    if(time % 2 == 0){
        myled = 0;
        oled.setTextColor(WHITE, BLACK);   
    }else{
        myled = 1;        
        oled.setTextColor(BLACK, WHITE);    
    }
    if(*state != 0){
        oled.setTextColor(WHITE, BLACK);
        myled = 0;    
    }
}

void screenTimerRun(int8_t *state, int8_t *screen, int32_t *timeTimer, int8_t *digitsTimer, bool *alarmRunning){
    switch(*state){
    case -1:
        setButsMeaning(EMPTY, STOP);
        indexTone = 0;
        rele = 1;
        myled = 1;
        tTimer.reset();
        tTimer.start();
        *timeTimer = 1000 * (10*60*digitsTimer[0] + 60*digitsTimer[1] + 10*digitsTimer[2] + digitsTimer[3]);    //ms
        *state = 0; 
        break;
    case 0:
        if(but2Action){
            tTimer.stop();
            alarm.detach();
            buzzer.write(0.00f);
            *alarmRunning = false;
            rele = 0;
            myled = 0;
            oled.setTextColor(WHITE, BLACK);
            setButsMeaning(RESET, START);
            *state = 1;            
        }
        break;
    case 1:
        if(but2Action){
            tTimer.start();
            rele = 1;
            myled = 1;
            setButsMeaning(EMPTY, STOP);
            *state = 0;            
        }
        if(but1Action){
            setButsMeaning(BACK, START);
            *state = 5;
            needClear = true;
            *screen = TIMER;            
        }        
        break;
    }
    if(but1Action || but2Action || *state == 0){    
        int time_ms = *timeTimer - tTimer.read_ms();
        int time_sec = time_ms / 1000;
        int time_min = time_sec / 60;
        char buf[10];
        if(time_ms <= 0){
            blinkAlarm(time_ms / 100, state);
            if(*state == 0 && !*alarmRunning){
                alarm.attach(&alarmSound, 0.25);
                rele = 0;
                *alarmRunning = true;}          
            sprintf(buf, "-%02d:%02d.%03d", abs(time_min), abs(time_sec-time_min*60), abs(time_ms-time_sec*1000));
            oled.writeString(0, Y_SOLO, buf, &updatedBuff);        
        }else{
            sprintf(buf, "%02d:%02d.%03d", time_min, time_sec-time_min*60, time_ms-time_sec*1000);
            oled.writeString(10, Y_SOLO, buf, &updatedBuff);   
        } 
    }  
}

void startupMelody(bool on){
    if(on){
        for(int8_t i = 0; i<19; i++){
        myled = !myled;
        playTone(melodyInit[i], durationInit[i]);}        
    }
}

int main() {
    int8_t screen = MENU;
    int32_t timeTimer = 0;
    int8_t digitsTimer[] = {0, 0, 0, 0};
    int8_t state = -1;
    bool alarmRunning = false;
    but1Action = false;
    but2Action = false;
    needClear = false;
    updatedBuff = false;
    t1.start();
    t2.start();
    
    myled = 1; // LED is ON
    oled.begin(SSD1306_SWITCHCAPVCC);
    oled.setTextSize(2);       
    oled.writeString(15, Y_SOLO, "STARTING", &updatedBuff);
    oled.display();
    oled.display();
    oled.clearDisplay();  
    
    startupMelody(true);
    myled = 0;
    
    while(1) {
        readButtons();
        switch(screen){
            case MENU:
                screenMenu(&state, &screen);
                break;
            case STOPWATCH:
                screenStopwatch(&state, &screen);
                break;
            case TIMER:
                screenTimer(&state, &screen, digitsTimer);
                break;
            case RUNTIMER:
                screenTimerRun(&state, &screen, &timeTimer, digitsTimer, &alarmRunning);
                break;
        }
        if(needClear) oled.clearDisplay();
        if(updatedBuff){
            updateButsMeaning();
            oled.display();
            oled.display();
            updatedBuff = !updatedBuff;              
        }     
        but1Action = false;
        but2Action = false;
        needClear = false;
    }
}
