#include "Stepper.h"
#include "mbed.h"

Stepper::Stepper(PinName _en, PinName _stepPin, PinName _dir, float step_per_mm):en(_en),
    stepPin(_stepPin),
    direction(_dir)
{
    Step_Per_MM = step_per_mm;
}

void Stepper::step(int number, int dir, float speed)
{
    if (dir == 1) {
        direction = 0;
    } else if (dir == 0) {
        direction = 1;
    }
    
    //  Step...
    for(int i=0; i<number; i++)
    {
        stepPin = 1;
        wait_us(5);
        stepPin = 0;
        wait_us(5);
        wait(speed);
    }
}

void Stepper::mm(int number, int dir)
{
    step(number*Step_Per_MM, dir, DELAY-0.001);
}

void Stepper::enable()
{
    en = 0;
}

void Stepper::disable()
{
    en = 1;
}