#include "Odometry.h"

#define dt 10000

InterruptIn button(USER_BUTTON);
DigitalOut led(LED1);
Ticker ticker;
Serial pc(USBTX, USBRX);
//Serial pc(PA_9, PA_10);
RoboClaw roboclaw(115200, PA_11, PA_12);
Odometry odo(47.4, 47.1, 242.0, roboclaw);

void update_main(void);
void init(void);

int main(void)
{   
    init();
    odo.GotoXYT(2250,500,0);
    while(1);
}

void init(void)
{
    pc.baud(115200);
    pc.printf("Hello from main !\n\r");
    roboclaw.ForwardM1(ADR, 0);
    roboclaw.ForwardM2(ADR, 0);
    wait_ms(500);
    roboclaw.ResetEnc(ADR);
    odo.setPos(1500, 1000, 2*PI/3);
    ticker.attach_us(&update_main,dt); // 100 Hz
}

void update_main(void)
{
    odo.update_odo();
    //pc.printf("EncM1 : %6d\tEncM2 : %6d\tTheta : %3.2f\n\r", roboclaw.ReadEncM1(ADR), roboclaw.ReadEncM2(ADR), odo.getTheta()*180/PI);
    //if(pc.readable()) if(pc.getc()=='l') led = !led;
}
