#include "mbed.h"
#include "AX12.h"

#define CR 1 //Continuous rotation
#define BR_AX12 250000 //Baud Rate des AX12
#define ARRET 0
#define AVANT 1
#define GAUCHE 2
#define DROITE 3
#define ARRIERE 4
#define AVGAUCHE 5
#define AVDROIT 6
#define ARDROIT 7
#define ARGAUCHE 8

Timer t;

AX12 FRONT_RIGHT (PA_9, PA_10, 6, BR_AX12); //Left Rear Motor
AX12 FRONT_LEFT (PA_9, PA_10, 7, BR_AX12); //Right Rear Motor
AX12 REAR_RIGHT (PA_9, PA_10, 4, BR_AX12); //Right Front Motor
AX12 REAR_LEFT (PA_9, PA_10, 1, BR_AX12); //Left Front Motor

Serial blue(PA_11, PA_12);
//Serial pc(USBTX, USBRX);

DigitalOut led(LED1);

void init(void);
void test(void);
void machine_etat(char etat);

float cmd = 0, consigne = 0.9, coef = 0.6, coef_full = 0.6;
int etat = ARRET;

/***********
Controle du robot depuis Application Android
Lettres correspondantes aux fleches :
haut :          z
bas :           x
droite :        d
gauche :        q
haut gauche :   a
haut droit :    e
bas gauche :    w
bas droit :     c
***********/

int main()
{
    init();
    t.start();
    //update.attach(&machine_etat,0.01);
    //test();
    //FRONT_RIGHT.SetCRSpeed(0.5);
    blue.printf("GO\r\n");
    while(1) {
        while(blue.readable()) 
        {
            char c = blue.getc();
            if(c=='s')
            {
                t.stop();
                blue.printf("Etat : %d pendant %2.6f secondes\r\n",etat,t.read());
                etat = ARRET;
            }
            else if(c=='z') etat = AVANT;
            else if(c=='q') etat = GAUCHE;
            else if(c=='d') etat = DROITE;
            else if(c=='x') etat = ARRIERE;
            else if(c=='a') 
            {
                etat = AVGAUCHE;
                consigne = 1.0;
            } 
            else if(c=='e') 
            {
                etat = AVDROIT;
                consigne = 1.0;
            } 
            else if(c=='c') 
            {
                etat = ARDROIT;
                consigne = 1.0;
            } 
            else if(c=='w') 
            {
                etat = ARGAUCHE;
                consigne = 1.0;
            }
            t.reset();
            t.start();
            machine_etat(etat);
        }
        wait(0.1);
    }
}

void machine_etat(char etat)
{
    switch(etat) {
        case ARRET:
            FRONT_RIGHT.SetCRSpeed(0);
            FRONT_LEFT.SetCRSpeed(0);
            REAR_RIGHT.SetCRSpeed(0);
            REAR_LEFT.SetCRSpeed(0);
            break;

        case AVANT:
            FRONT_RIGHT.SetCRSpeed(-consigne);
            FRONT_LEFT.SetCRSpeed(consigne);
            REAR_RIGHT.SetCRSpeed(-consigne);
            REAR_LEFT.SetCRSpeed(consigne);
            break;

        case GAUCHE:
            FRONT_RIGHT.SetCRSpeed(-coef_full);
            FRONT_LEFT.SetCRSpeed(-coef_full);
            REAR_RIGHT.SetCRSpeed(-coef_full);
            REAR_LEFT.SetCRSpeed(-coef_full);
            break;

        case DROITE:
            FRONT_RIGHT.SetCRSpeed(coef);
            FRONT_LEFT.SetCRSpeed(coef);
            REAR_RIGHT.SetCRSpeed(coef);
            REAR_LEFT.SetCRSpeed(coef);
            break;


        case ARRIERE:
            FRONT_RIGHT.SetCRSpeed(consigne);
            FRONT_LEFT.SetCRSpeed(-consigne);
            REAR_RIGHT.SetCRSpeed(consigne);
            REAR_LEFT.SetCRSpeed(-consigne);
            break;

        case AVGAUCHE:
            FRONT_RIGHT.SetCRSpeed(-consigne);
            FRONT_LEFT.SetCRSpeed(consigne*coef);
            REAR_RIGHT.SetCRSpeed(-consigne);
            REAR_LEFT.SetCRSpeed(consigne*coef);
            break;

        case AVDROIT:
            FRONT_RIGHT.SetCRSpeed(-consigne*coef);
            FRONT_LEFT.SetCRSpeed(consigne);
            REAR_RIGHT.SetCRSpeed(-consigne*coef);
            REAR_LEFT.SetCRSpeed(consigne);
            break;

        case ARDROIT:
            FRONT_RIGHT.SetCRSpeed(consigne*coef);
            FRONT_LEFT.SetCRSpeed(-consigne);
            REAR_RIGHT.SetCRSpeed(consigne*coef);
            REAR_LEFT.SetCRSpeed(-consigne);
            break;


        case ARGAUCHE:
            FRONT_RIGHT.SetCRSpeed(consigne);
            FRONT_LEFT.SetCRSpeed(-consigne*coef);
            REAR_RIGHT.SetCRSpeed(consigne);
            REAR_LEFT.SetCRSpeed(-consigne*coef);
            break;

        default:
            FRONT_RIGHT.SetCRSpeed(0);
            FRONT_LEFT.SetCRSpeed(0);
            REAR_RIGHT.SetCRSpeed(0);
            REAR_LEFT.SetCRSpeed(0);
            break;
    }
}

void init(void)
{
    blue.baud(9600);
    blue.printf("okay\r\n");
    FRONT_RIGHT.SetMode(CR);
    FRONT_LEFT.SetMode(CR);
}

void test(void)
{
    FRONT_RIGHT.SetCRSpeed(consigne);
    FRONT_LEFT.SetCRSpeed(consigne);
    REAR_RIGHT.SetCRSpeed(consigne);
    REAR_LEFT.SetCRSpeed(consigne);
    wait(1.0);
    FRONT_RIGHT.SetCRSpeed(1.0);
    FRONT_LEFT.SetCRSpeed(-1.0);
    REAR_RIGHT.SetCRSpeed(1.0);
    REAR_LEFT.SetCRSpeed(-1.0);
    wait(1.0);
    FRONT_RIGHT.SetCRSpeed(0);
    FRONT_LEFT.SetCRSpeed(0);
    REAR_RIGHT.SetCRSpeed(0);
    REAR_LEFT.SetCRSpeed(0);
}
