#ifndef LEGINTERFACE_H
#define LEGINTERFACE_H
#include "I2CTransaction.h"
#include "leg_packets.h"
#include "robot_config.h"





class LegInterface
{
public:
    // Indices for the different legs
    enum Leg {LEG_W=0, LEG_E, LEG_S, NUM_LEGS};

    // An array of I2C addresses indexable by enum Leg
    static const int LegAddress[];

    // Encoder to wheel
    static const float TICKS_PER_METER = 52633.97;

    // Angle between front legs
    static const float FRONT_LEG_ANGLE = 130;  // Degrees

    // Distance from center of robot to wheel
    //static const float ROBOT_RADIUS = 0.4702;  // m

    // Number of A2D ticks per meter.  TODO: is 4096 right?
    static const float LIFT_TICKS_PER_METER = 4096 / 0.1;

    // Offset between measured height and true height (m)
    //static const float LIFT_OFFSET = 0.01;
#if (ROBOT_CONFIG_LEG_SYMMETRY == 0)
    static const float LIFT_OFFSET = 0.015;
#else
    static const float LIFT_OFFSET = -0.005;
#endif

    LegInterface(Serial *pc = NULL);

    bool sendEstop(bool estop);
    bool queryStateInitiate();
    bool queryStateCompleted();
    bool queryStateSuccess();
    void queryStateReportMagic();
    bool queryEstopCompleted();
    bool queryEstopSuccess();
    bool queryStateWaitForCompletion(int timeout = 1000);
    bool queryStateCopy(LegState_t legState[NUM_LEGS]);
    bool queryStateCopy(float liftPosition[NUM_LEGS], float liftVelocity[NUM_LEGS], float wheelPosition[NUM_LEGS], float wheelVelocity[NUM_LEGS], bool cliff[NUM_LEGS], bool limit[NUM_LEGS], bool estop[NUM_LEGS], uint8_t magic[NUM_LEGS]);
    void displayLegState(LegState_t *legState);
    void queryStateTest(Serial *pc);
    bool queryLegParams(Leg leg, LegControlParams_t *liftParams, LegControlParams_t *wheelParams);
    void displayParams(LegControlParams_t *params);
    bool setLegParams(Leg leg, LegControlParams_t *liftParams, LegControlParams_t *wheelParams);
    bool setLegGoal(int32_t liftPos[NUM_LEGS], int32_t wheelVel[NUM_LEGS]);
    bool setLegGoal(float liftPos[NUM_LEGS], float wheelVel[NUM_LEGS]);
    bool getLegGoalCompleted();
    bool getLegGoalSuccess();
    void displayStatus();
    //bool getLegGoalStatus();
    void clearLegSetGoalStatus();
    void clearQueryTransactions();
    void clearSetGoalTransactions();
    static void reset();
    static void resetBus();
    static void cycleBus();
    static void initI2C(PinName sda, PinName scl);

private:
    I2CTransaction *transactionEstop[NUM_LEGS];
    LegPacket_t legPacketEstop;

    I2CTransaction *transactionQueryState[NUM_LEGS];
    LegPacket_t legPacketQuery;
    LegState_t legState[NUM_LEGS];

    I2CTransaction *transactionQueryLiftParams[NUM_LEGS];
    I2CTransaction *transactionQueryWheelParams[NUM_LEGS];
    LegPacket_t legPacketQueryLiftParams;
    LegPacket_t legPacketQueryWheelParams;
    LegControlParams_t legLiftParams;
    LegControlParams_t legWheelParams;

    I2CTransaction *transactionSetLiftParams[NUM_LEGS];
    I2CTransaction *transactionSetWheelParams[NUM_LEGS];
    LegPacket_t legPacketSetLiftParams;
    LegPacket_t legPacketSetWheelParams;

    I2CTransaction *transactionSetGoal[NUM_LEGS];
    LegPacket_t legPacketSetGoal[NUM_LEGS];
    Serial *pc;

};

#endif
