#ifndef I2CTRANSACTION_H
#define I2CTRANSACTION_H
#include "MODI2C.h"

class I2CTransaction
{
public:
    I2CTransaction(int address, char* writePacket, int writePacketLength, char* readPacket = NULL, int readPacketLength = 0);
    static void setFrequency(int frequency);
    static void setMaxRetry(int maxRetry);
    bool completed();
    int getStatus(int i);
    bool initiateTransaction();
    bool waitForCompletion(int timeout = 1000);
    void displayStatus(Serial *pc, char * strg);
    bool success();
    bool transmissionError(); 
    bool checkTransaction();
    void clearStatus();
    static int getI2CQueueLength();
    static void reset();
    static void resetBus();
    static void cycleBus();
    static void initI2C(PinName sda, PinName scl);

private:
    static MODI2C *i2c;

    int status[2];      // Status words for both the write and read halves of the transaction
    int address;
    char* writePacket;
    int writePacketLength;
    char* readPacket;
    int readPacketLength;
    int retryCount;
    static int maxRetryCount;
};


#endif

