/**
    Generic Ticker implementation that sets a boolean flag at a regular interval
    
    9/12/13 Andrew H. Fagg      Original
    
*/

#include "BooleanTicker.h"

/**
    Constructor.  Immediately starts the ticker.
    
    \param interval Interval from one flag setting to the next
*/

BooleanTicker::BooleanTicker(float interval){
    value = false;
    ticker.attach(this, &BooleanTicker::BooleanTickerCallback, interval);
}
    
/**
    Deconstructor
*/

BooleanTicker::~BooleanTicker(){
    ticker.detach();
}

/**
    Callback function: sets the flag
*/

void BooleanTicker::BooleanTickerCallback(){
    value = true;
}

/**
    Clear the flag (public)
*/
    
void BooleanTicker::clear(){
    __disable_irq();
    value = false;
    __enable_irq();
}

/**
    Set the flag (public)
*/
    
void BooleanTicker::set(){
    __disable_irq();
    value = true;
    __enable_irq();
}

/**
    Get the current flag state

    \return The current value of the flag.
*/

bool BooleanTicker::getValue(){
    return value;
}
