#include "mbed.h"
#include "USBSerial.h"

#include <time.h>

USBSerial vcom; // Virtual serial port over USB
Serial uart(P0_19, P0_18);

DigitalOut led0(P0_20);
DigitalOut led1(P0_21);
DigitalOut led2(P0_11);

void led_test()
{
    for (int i = 0; i < 10; i++) {
        led0 = !led0; wait(0.33);
        led1 = !led1; wait(0.33);
        led2 = !led2; wait(0.33);
    }
    led0 = led1 = led2 = 1;
    uart.printf("led_test done!\r\n");
}

DigitalIn button(P0_1, PullUp);
struct InterruptTest {
    InterruptTest(PinName pin) : _ini(pin) {
        _ini.mode(PullNone);
        _ini.rise(callback(this, &InterruptTest::on_rise));
        _ini.fall(callback(this, &InterruptTest::on_fall));
        _rises = _falls = 0;
    }

    int rises() { return _rises; }
    int falls() { return _falls; }

private:
    void on_rise() {
        led1 = !led1;
        _rises++;
    }
        
    void on_fall() {
        led2 = !led2;
        _falls++;
    }
    
private:
    InterruptIn _ini;
    int _rises, _falls;
};

void button_test()
{
    DigitalIn btn(P0_1, PullUp);
    
    uart.printf("button input test start(10s) %d:\r\n", clock());
    
    int count = 0;
    clock_t start = clock();
    while (clock() - start <= 10*CLOCKS_PER_SEC) {
        led2 = btn.read();
        if (!led2) {
            count++;
        }
    }
    uart.printf("\r\n");
    uart.printf("button input test done! count: %d, %d\r\n", count, clock());
}

void interrupt_test()
{
    uart.printf("button interrupt test start(10s) %d:\r\n", clock());
    InterruptTest it(P0_1);
    wait(10);
    uart.printf("button interrupt test done, %d\r\n", clock());
    uart.printf("rises: %d, falls: %d\r\n", it.rises(), it.falls());
}

void check_button()
{
    led2 = button.read();
}

int main(void) {
    uart.baud(115200);
    uart.format();
    
    uart.printf("BUILD: %s %s\r\n", __DATE__, __TIME__);
    uart.printf("System core clock: %d\r\n", SystemCoreClock);
    
//    led_test();
//    button_test();
//    interrupt_test();
    
    Ticker ticker;
    ticker.attach_us(check_button, 10000);
    
    while(1) {
//        led2 = button.read();
        clock_t ts = clock();
        
        uart.printf("Hello UART! %d\r\n", ts);
        vcom.printf("I am a virtual vcom port %d\r\n", ts);
        
        led0 = !led0; wait(1);
        led1 = !led1; wait(1);
        // led2 = !led2; wait(1);
    }
}
