/*
 * Copyright (c) 2015 Switch Science, Inc.
 *      https://international.switch-science.com/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include "mbed.h"
#include "MusicEngine.h"
#include "TSL2561.h"


I2C  i2c( dp4,dp5);
TSL2561      lum( i2c , TSL2561_ADDRESS_FLOAT );         // TSL2561 SDA, SCL (Data available every 400mSec)      // TSL2561 SDA, SCL (Data available every 400mSec)


MusicEngine Speaker(dp15);
Serial pc(USBTX, USBRX);
int brightness = 15;

int main()
{
    pc.baud(9600);

    while(1) {
        pc.printf("Illuminance: %+7.2f [Lux]\r\n", lum.lux());
        if(lum.lux() > brightness) {
            Speaker.play("T120L4CDEFEDCREFGAGFERCR4CR4CR4CR4CDEFEDC");
            wait(15);
        }
        wait(1);
    }
}