/*
 *  I2C digital temperature sensor "LM75B" library
 *
 *  LM75B is an I2C based digital temperature sensor
 *  http://www.nxp.com/pip/LM75B_2.html
 *
 *  This is a library to operate this chip easy.
 *
 *  Copyright (c) 2010 Tedd OKANO
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  revision 1.0  16-Jan-2010   a. 1st release
 *  revision 1.1  23-Jan-2010   a. class name has been changed from LM75B to TempSensor_LM75B
 *                              b. copyright notice added
 */

#ifndef        MBED_TempSensor_LM75B
#define        MBED_TempSensor_LM75B


#include    "mbed.h"
#include    "I2cBusDevice.h"


//  LM75B IIC address
const char    LM75B_base_addr = 0x90;

//  LM75B registers
const char    Conf            = 0x01;
const char    Temp            = 0x00;
const char    Tos             = 0x03;
const char    Thyst           = 0x02;


class TempSensor_LM75B : I2cBusDevice {
public:

    TempSensor_LM75B( I2C *i2c, char dev_address = LM75B_base_addr, char vConf = 0x00, short vTos  = 0x5000, short vThyst = 0x4B00 ) : I2cBusDevice( i2c, dev_address ) {
        char    data[ 3 ];

        data[ 0 ]    = Conf;
        data[ 1 ]    = vConf;

        if ( write( data, 2 ) )
            ;

        data[ 0 ]    = Tos;
        data[ 1 ]    = (char)(vTos >> 8);
        data[ 2 ]    = (char)vTos;

        if ( write( data, 3 ) )
            ;

        data[ 0 ]    = Thyst;
        data[ 1 ]    = (char)(vThyst >> 8);
        data[ 2 ]    = (char)vThyst;

        if ( write( data, 3 ) )
            ;
    }

    ~TempSensor_LM75B() {
    }

    int temp_short( void ) {
        char    data[ 2 ];

        if ( read( Temp, data, 2 ) )
            return ( 1e6 );

        return ( (((short)data[ 0 ]) << 8 | data[ 1 ]) >> 5 );
    }

    float temp( void ) {
        return ( (float)(temp_short()) / 8.0 );
    }

    operator float( void ) {
        return( temp() );
    }

#if 0
    operator short( void ) {
        return( temp_short() );
    }
#endif



private:
}
;

#endif