/*******************************************************************************
 * Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */

#include "mbed.h"
#include "max32625.h"
#include "ioman_regs.h"
#include "gpio_regs.h"
#include "PinNames.h"
#include "max32625pico.h"

//******************************************************************************
MAX32625PICO::MAX32625PICO() : en3V3(P3_6, 0), enIOH(P2_2, 0), selSWD(P2_3, 0)
{
}

//******************************************************************************
MAX32625PICO::MAX32625PICO(vddioh_mode_t iohMode, vio_t dipVio, vio_t swdVio) : en3V3(P3_6, 0), enIOH(P2_2, 0), selSWD(P2_3, 0)
{
    init(iohMode, dipVio, swdVio);
}

//******************************************************************************
MAX32625PICO::~MAX32625PICO()
{
}

//******************************************************************************
int MAX32625PICO::init(vddioh_mode_t iohMode, vio_t dipVio, vio_t swdVio)
{
    // Set LED pins to open drain
    uint32_t out_mode = MXC_GPIO->out_mode[2];
    out_mode &= ~(0xFFF0000);  // Clear modes for bits 4-6
    out_mode |=  (MXC_V_GPIO_OUT_MODE_OPEN_DRAIN << (4 * 4)) 
                |(MXC_V_GPIO_OUT_MODE_OPEN_DRAIN << (5 * 4))
                |(MXC_V_GPIO_OUT_MODE_OPEN_DRAIN << (6 * 4));
    MXC_GPIO->out_mode[2] = out_mode;

    en3V3 = 0;   // Disable local 3.3V IOH supply by default
    enIOH = 0;   // Disable external IOH supply by default
    selSWD = 0;  // Select DIP pins by default
    
        
    switch (iohMode) {
        case IOH_SWD_IN :
            selSWD = 1;  // Use SWD pins
        case IOH_DIP_IN :
            enIOH = 1;   // Enable external connections
            break;
        case IOH_SWD_OUT :
            selSWD = 1;  // Use SWD pins
        case IOH_DIP_OUT :
            enIOH = 1;   // Enable external connections
        case IOH_3V3 :
            en3V3 = 1;   // Enable local 3.3V supply connection to IOH
            break;
        case IOH_OFF :
        default:
            break;

    }

    // Set DIP pin ports to dipVio
    vddioh(P0_0, dipVio);
    vddioh(P0_1, dipVio);
    vddioh(P0_2, dipVio);
    vddioh(P0_3, dipVio);
    vddioh(P0_4, dipVio);
    vddioh(P0_5, dipVio);
    vddioh(P0_6, dipVio);
    vddioh(P0_7, dipVio);
    vddioh(P1_6, dipVio);
    vddioh(P1_7, dipVio);
    vddioh(P4_4, dipVio);
    vddioh(P4_5, dipVio);
    vddioh(P4_6, dipVio);
    vddioh(P4_7, dipVio);
    // Set SWD pin ports to swdVio
    vddioh(P3_0, swdVio);
    vddioh(P3_1, swdVio);
    vddioh(P3_2, swdVio);
    vddioh(P3_3, swdVio);
    vddioh(P3_4, swdVio);
    vddioh(P3_7, swdVio);

    // Set 1-Wire port to VDDIOH
    vddioh(P4_0, VIO_IOH);
    vddioh(P4_1, VIO_IOH);

    return 0;
}

//******************************************************************************
int MAX32625PICO::vddioh(PinName pin, vio_t vio)
{
    __IO uint32_t *use_vddioh = &((mxc_ioman_regs_t *)MXC_IOMAN)->use_vddioh_0;

    if (pin == NOT_CONNECTED) {
        return -1;
    }

    use_vddioh += PINNAME_TO_PORT(pin) >> 2;
    if (vio) {
        *use_vddioh |= (1 << (PINNAME_TO_PIN(pin) + ((PINNAME_TO_PORT(pin) & 0x3) << 3)));
    } else {
        *use_vddioh &= ~(1 << (PINNAME_TO_PIN(pin) + ((PINNAME_TO_PORT(pin) & 0x3) << 3)));
    }

    return 0;
}
