#include "mbed.h"
#include "adc.h"

DigitalOut led1(LED1);

// main() runs in its own thread in the OS
int main()
{
    uint16_t adc_value;
    unsigned int overflow;

    /* Initialize ADC */
    ADC_Init();

    while (true) {
        led1 = !led1;
        ADC_StartConvert(ADC_CH_0, 0, 1); // AIN0
        overflow = (ADC_GetData(&adc_value) == E_OVERFLOW ? 1 : 0);
        printf("AIN0: 0x%04x%s\n", adc_value, overflow ? "*" : " ");
        ADC_StartConvert(ADC_CH_1, 0, 1); // AIN1
        overflow = (ADC_GetData(&adc_value) == E_OVERFLOW ? 1 : 0);
        printf("AIN1: 0x%04x%s\n", adc_value, overflow ? "*" : " ");
        ADC_StartConvert(ADC_CH_2, 0, 1); // AIN2
        overflow = (ADC_GetData(&adc_value) == E_OVERFLOW ? 1 : 0);
        printf("AIN2: 0x%04x%s\n", adc_value, overflow ? "*" : " ");
        ADC_StartConvert(ADC_CH_3, 0, 1); // AIN3
        overflow = (ADC_GetData(&adc_value) == E_OVERFLOW ? 1 : 0);
        printf("AIN3: 0x%04x%s\n", adc_value, overflow ? "*" : " ");
        ADC_StartConvert(ADC_CH_0_DIV_5, 0, 1); // AIN0 div 5
        overflow = (ADC_GetData(&adc_value) == E_OVERFLOW ? 1 : 0);
        printf("AIN0/5: 0x%04x%s\n", adc_value, overflow ? "*" : " ");
        ADC_StartConvert(ADC_CH_1_DIV_5, 0, 1); // AIN1 div 5
        overflow = (ADC_GetData(&adc_value) == E_OVERFLOW ? 1 : 0);
        printf("AIN1/5: 0x%04x%s\n", adc_value, overflow ? "*" : " ");
        ADC_StartConvert(ADC_CH_VDDB_DIV_4, 0, 1); // AIN2
        overflow = (ADC_GetData(&adc_value) == E_OVERFLOW ? 1 : 0);
        printf("VDDB/4: 0x%04x%s\n", adc_value, overflow ? "*" : " ");
        ADC_StartConvert(ADC_CH_VDD18, 0, 1); // AIN3
        overflow = (ADC_GetData(&adc_value) == E_OVERFLOW ? 1 : 0);
        printf("VDD18: 0x%04x%s\n", adc_value, overflow ? "*" : " ");
        ADC_StartConvert(ADC_CH_VDD12, 0, 1); // AIN3
        overflow = (ADC_GetData(&adc_value) == E_OVERFLOW ? 1 : 0);
        printf("VDD12: 0x%04x%s\n", adc_value, overflow ? "*" : " ");
        ADC_StartConvert(ADC_CH_VRTC_DIV_2, 0, 1); // AIN0 div 5
        overflow = (ADC_GetData(&adc_value) == E_OVERFLOW ? 1 : 0);
        printf("VRTC/2: 0x%04x%s\n", adc_value, overflow ? "*" : " ");
        ADC_StartConvert(ADC_CH_TMON, 0, 1); // AIN1 div 5
        overflow = (ADC_GetData(&adc_value) == E_OVERFLOW ? 1 : 0);
        printf("TMON: 0x%04x%s\n", adc_value, overflow ? "*" : " ");
        wait(0.5);
    }
}

