#include "mbed.h"
#include "max32630fthr.h"
#include "SDFileSystem.h"

MAX32630FTHR pegasus;

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);

SDFileSystem sd(P0_5, P0_6, P0_4, P0_7, "sd");  // mosi, miso, sclk, cs

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main()
{
    gLED = LED_OFF;
    rLED = LED_ON;
    
    pegasus.init(MAX32630FTHR::VIO_3V3);
    gLED = LED_ON;

    FILE *fp = fopen("/sd/myfile.txt", "w");
    fprintf(fp, "Hello World!\n");
    fclose(fp);
    rLED = LED_OFF;

    while (true) {
        gLED = !gLED;
        Thread::wait(500);
    }
}

