#include "mbed.h"
#include "rtos.h"
#include "PinDetect.h"
#include "uLCD_4DGL.h"
uLCD_4DGL uLCD(p28, p27, p30);
#include "Robot.h"
#include "Nav_Switch.h"
#include "Speaker.h"
#include "wave_player.h"
#include "SDFileSystem.h"
BusOut mbedleds(LED1,LED2,LED3,LED4);
Robot myRobot;
Nav_Switch myNav( p25, p22, p23, p21, p24);
Mutex stdio_mutex;
AnalogOut DACout(p18); // used to play sound on speaker
wave_player waver(&DACout);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card setup
//PinDetect pb1(p25);
//Wiring Set-up:
//Speaker: p18
//SD Card: DO=p6,SCK=p7,DI=p5,CS=p8,VCC=Vout,GND=GND
//Thumb-Stick: U=p25,C=p24,L=p23,D=p22,R=p21,+=pVout,-=GND
bool Alive = 1;
bool Drown = 0;
bool Splat = 0;
bool Victory = 0;
double CarWidth = 10;
int i = 11;
int j = 11;
int C1 = 11;
int C2 = 32;
int C3 = 53;
int C4 = 74;
int C5 = 95;
int C6 = 116;
double Position1 = 90;
double Position2 = 90;
double Column1;
double Column2;
int Rate1 = 3;
int FrogX;
int FrogY;
    
/*void pb1_hit_callback (void)
{
    stdio_mutex.lock();
    myRobot.moveForward();
    stdio_mutex.unlock();   
}*/
  
void DeathCheck_thread(void const *argument)
{
    while(Alive) {
        FrogX = myRobot.getXPosition();
        FrogY = myRobot.getYPosition(); 
    
        if(FrogY == 32){   //Check win-condition on landing on Row 2
            Alive = 0;
            stdio_mutex.lock();
            uLCD.locate(1,1);
            uLCD.printf("VICTORY!");
            stdio_mutex.unlock();
            }//End 53
        if(FrogY == 74){   //Check dangers on water Row 4
            if(FrogX == 32 || FrogX == 74 || FrogX == 116){
                Alive = 0;
                Drown = 1;
                
                stdio_mutex.lock();
                myRobot.drawDrown1();
                stdio_mutex.unlock();
                Thread::wait(150);
                stdio_mutex.lock();
                myRobot.drawDrown2();
                stdio_mutex.unlock();
                Thread::wait(150);
                stdio_mutex.lock();
                myRobot.drawDrown3();
                stdio_mutex.unlock();
                Thread::wait(150);
                stdio_mutex.lock();
                myRobot.drawDrown4();
                stdio_mutex.unlock();
                Thread::wait(150);
                stdio_mutex.lock();
                myRobot.drawDrown5();
                stdio_mutex.unlock();
                }
        }//End 74
    Thread::wait(10);
    }//End While    
}//End Thread

void AutoPilot_thread(void const *argument)
{
    while(Alive) {
    //Auto-pilot Testing
       
    //stdio_mutex.lock();
    //myRobot.drawEraser();
    //myRobot.moveForward();
    //myRobot.drawFrog();
    //stdio_mutex.unlock();
    //Thread::wait(50);
    
    break;
    }
}

void Traffic1_thread(void const *argument) //Blue Car
{
    while(Alive) {
        Position1 = Position1 + Rate1;
        if(Position1 > 140 ){
            Position1 = -10;
            }
            
        if(FrogY == 95){   //Check dangers on Traffic 1 Row 5                
            if(((Position1 + CarWidth)>(FrogX - 5)) && ((Position1 - CarWidth)<(FrogX + 5))){                        
                Alive = 0;
                stdio_mutex.lock();
                myRobot.drawDeadFrog();
                stdio_mutex.unlock();
            }    
        }    
        Column1 = (ceil((Position1 - CarWidth)/21))*21;
        
        /*stdio_mutex.lock();
        uLCD.locate(10,1);
        uLCD.printf("%3.0f", Column1);
        stdio_mutex.unlock();
        */
        stdio_mutex.lock();
        //myRobot.drawRoad(Column1-10,95);
        //myRobot.drawRoad(Column1-31,95);
        myRobot.drawCar1(Position1,CarWidth);
        stdio_mutex.unlock();
        Thread::wait(10);
    }
}

void Traffic2_thread(void const *argument)  //Red Car
{
    while(Alive) {
        Position2 = Position2 - Rate1;
        if(Position2 < -12 ){
            Position2 = 140;
            }
        
        if(FrogY == 53){   //Check dangers on Traffic 2 Row 3               
            if(((Position2 + CarWidth)>(FrogX - 5)) && ((Position2 - CarWidth)<(FrogX + 5))){                               
                Alive = 0;
                stdio_mutex.lock();
                myRobot.drawDeadFrog();
                stdio_mutex.unlock();
            }    
        }  
        Column2 = (ceil((Position2 - CarWidth)/21))*21;
        stdio_mutex.lock();
        //myRobot.drawRoad(Column2+10,53);
        //myRobot.drawRoad(Column2+31,53);
        myRobot.drawCar2(Position2,CarWidth);
        stdio_mutex.unlock();
        Thread::wait(30);
    }
}

void SFX_thread(void const *argument)
{
    while(1){
    if(Alive == 1){
        //stdio_mutex.lock();
        //uLCD.locate(1,1);
        //uLCD.printf("DRY");
        //stdio_mutex.unlock();
        }
    
    if(Drown == 1){
        //stdio_mutex.lock();
        //uLCD.locate(1,1);
        //uLCD.printf("SPLASH!");
        //stdio_mutex.unlock();
        
        FILE *wave_file;
        wave_file=fopen("/sd/Splash.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
        }
    if(Splat == 1){
        stdio_mutex.lock();
        uLCD.locate(1,1);
        uLCD.printf("SPLAT!");
        stdio_mutex.unlock();
        
        FILE *wave_file;
        wave_file=fopen("/sd/Splat.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
        }
         if(Victory == 1){
        stdio_mutex.lock();
        uLCD.locate(1,1);
        uLCD.printf("Victory!");
        stdio_mutex.unlock();
        
        FILE *wave_file;
        wave_file=fopen("/sd/Victory.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
        }
    Thread::wait(10);
    }
}

void Location_thread(void const *argument)
{
    while(1){
        //stdio_mutex.lock();
        //uLCD.locate(1,1);
        //uLCD.printf("%5.0d", myRobot.getXPosition());
        //uLCD.locate(8,1);
        //uLCD.printf("%5.0d", myRobot.getYPosition());
        //stdio_mutex.unlock();
    Thread::wait(10);
    }
}

void ThumbStick_thread(void const *argument)
{
    while(1) {
            // Player Movement checked with navigation switch
            if (myNav.left() ) 
            {            
                stdio_mutex.lock();
                myRobot.moveLeft();
                stdio_mutex.unlock();   
            } 
            
            if (myNav.right()) 
            {             
                stdio_mutex.lock(); 
                myRobot.moveRight();  
                stdio_mutex.unlock();             
            }
            
            if (myNav.up()) 
            {                
                stdio_mutex.lock();
                myRobot.moveForward();
                stdio_mutex.unlock();              
            }
            
            if (myNav.down()) 
            {
                stdio_mutex.lock();
                myRobot.moveBackward();
                stdio_mutex.unlock(); 
            }
        Thread::wait(150);
    }
}

int main()
{
    //pb1.mode(PullUp);
    // Delay for initial pullup to take effect
    //Thread::wait(1000*.01);
    // Setup Interrupt callback functions for a pb hit
    //pb1.attach_deasserted(&pb1_hit_callback);
    // Start sampling pb inputs using interrupts
    //pb1.setSampleFrequency();
    //Initialize Background
    uLCD.baudrate(500000);
    uLCD.filled_rectangle(0, 0 , 127, 127, RED); 
    myRobot.drawOutline();
    while(i <= 116){  
        while(j <= 116){    
        myRobot.drawHelper(i,j);
        j = j + 21;
        }
    j = 11;
    i = i + 21;
    }
    myRobot.drawFrog();
    
    Thread thread1(AutoPilot_thread);
    Thread thread2(Location_thread);
    Thread thread3(ThumbStick_thread);
    Thread thread4(SFX_thread);
    Thread thread5(Traffic1_thread);
    Thread thread6(Traffic2_thread);
    Thread thread7(DeathCheck_thread);
    
    while (1) {
        
        Thread::wait(500);
    }
}