#include "mbed.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "VS1002.h"

uLCD_4DGL uLCD(p28, p27, p30);

DigitalIn Dreq(p26);
DigitalOut XDCS(p25);
DigitalOut reset(p23);
DigitalOut XCS(p22);

SPI mp3Board(p11, p12, p13); // mosi, miso, sclk
SDFileSystem sd(p5, p6, p7, p8, "sd"); // DI, DO, SCK, CS

int killLoop = 1;
int mp3Chunk;
int fileSize;

long getFileSize(FILE *fp) {
    fseek(fp, 0, SEEK_END);
    int size = ftell(fp);
    fseek(fp, 0, SEEK_SET);
    return size;
}

void sdi_write(unsigned char datum)
{
    XCS = 1;  
    XDCS = 1;
    XCS = 0;   
    while(!Dreq);
    mp3Board.write(datum);
    XCS = 1;
}

/*
void sdi_write(unsigned char datum)
{
    _CS = 1;  
    _DCS = 1;
    _CS = 0;   
    while(!_DREQ);
    _spi.write(datum);
    _CS = 1;
}
////////////////////////////////////////////////////////////////////////////
VS1002::VS1002(
PinName mmosi, PinName mmiso, PinName ssck, PinName ccs, const char *name,
         PinName mosi, PinName miso, PinName sck, PinName cs, PinName rst,
         PinName dreq, PinName dcs, PinName vol)
    :
     _sd(mmosi, mmiso, ssck, ccs, name),
     _spi(mosi, miso, sck), 
     _CS(cs), 
     _RST(rst), 
     _DREQ(dreq),
     _DCS(dcs), 
     _VOL(vol) {
    
    }    */
///////////////////////////////////////////////////////////////////////////

int main() {
    reset = 1;
    //Sine test // So, the simplified procedure is:
    XDCS = 1; //1) Always keep XDCS at logical 1.
    XCS = 0; //2) Set XCS to 0, 
    mp3Board.write(0x02); //0x02 is the write opcode
    mp3Board.write(0x00); //0x00 is the address of the sci mode register
    mp3Board.write(0x0A); //0x0A (11 in dec) is the SM_SDINEW bit    //send SCI command to set SCI_MODE with SM_SHARED and SM_SDINEW set to 1, 
    XCS = 1;    //then set XCS back to 1.
    mp3Board.write(0x53); //3) While XCS is 1, send sine test activation bytes, e.g. 0x53 0xef 0x6e 0x7e 0x00 0x00 0x00 0x00.
    mp3Board.write(0xEF);
    mp3Board.write(0x6E);
    mp3Board.write(0x44);
    mp3Board.write(0x00);
    mp3Board.write(0x00);
    mp3Board.write(0x00);
    mp3Board.write(0x00);
    
    
    /*
    mp3Board.frequency(12000000);
    XCS=1;
    XCS=0; //pull xcs low to begin sci write. Sets mode to vs1002, 
    mp3Board.write(0x02); //0x02 is the write opcode
    mp3Board.write(0x00); //0x00 is the address of the sci mode register
    mp3Board.write(0x0A); //0x0A (11 in dec) is the SM_SDINEW bit
    XCS=1; //pulled high to end write sequence
    
    uLCD.locate(0,0);
    uLCD.printf("Initialized...");
    
    FILE *mp3_file;
    unsigned char mp3Chunk[512];
    mp3_file = fopen("/sd/GGW.mp3","rb");
    
    if (mp3_file !=NULL)
    {
        uLCD.locate(0,1);
        uLCD.printf("File found");
        XDCS = 1;
        XDCS = 0;
        fileSize=getFileSize(mp3_file);
            uLCD.locate(0,3);
            uLCD.printf("Filesize: ");
            uLCD.locate(0,4);
            uLCD.printf(" %i", fileSize);
        //fread(&mp3Chunk, 1, 1, mp3_file);
            uLCD.locate(0,5);
            uLCD.printf("mp3 file: ");
            uLCD.locate(0,6);
            uLCD.printf(" %i", mp3_file);
            uLCD.locate(0,7);
            //uLCD.printf("mp3 chunk: ");
            //uLCD.locate(0,8);
            //uLCD.printf(" %i", mp3Chunk);
        //would have funtion here passing the 8 bits to arm assembler code, hence the necessatity for 8 btis only!
        //mp3Board.write(mp3Chunk);
            uLCD.locate(0,10);
            uLCD.printf("File writing...");
//////////////////////////////////////////////////////////////////////////////
        fread(&mp3Chunk, 1, 512, mp3_file);
        for(int i=0; i<512; i++)
        {
            #ifndef FS_ONLY
            //mp3Board.write(mp3Chunk[i]);
            sdi_write(mp3Chunk[i]);
                uLCD.locate(0,11);
                uLCD.printf("... %i", i);
                uLCD.locate(0,12);
                uLCD.printf(".. %i", mp3Chunk[i]);
            #endif
        }
        #ifndef FS_ONLY
            //Volume set to 0 dB
            XCS = 1; 
            XDCS = 1;
            XCS = 0;                               //enables SCI/disables SDI
            while(!Dreq);                            //wait unitl data request is high
            mp3Board.write(0x02);                        //SCI write
            mp3Board.write(0x0B);                    //register address
            mp3Board.write((0 >> 8) & 0xFF);            //write out first half of data word
            mp3Board.write(0 & 0xFF);                //write out second half of data word
            XCS = 1;                                //enables SDI/disables SCI
            wait_us(5);
        #endif
        for(int n=0; n<2048; n++)
        {
            #ifndef FS_ONLY
            sdi_write(0x00);
                uLCD.locate(0,13);
                uLCD.printf("... %i", n);
            #endif
        }
////////////////////////////////////////////////////////////////////////   
        fclose(mp3_file);
            XDCS=1;
            uLCD.locate(0,14);
            uLCD.printf("File closing."); 
    }
    else
    {
        uLCD.locate(0,2);
        uLCD.printf("File not found");
    }
    return 0;*/
}