#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
uLCD_4DGL uLCD(p28, p27, p30);
#include "Robot.h"
#include "Nav_Switch.h"
BusOut mbedleds(LED1,LED2,LED3,LED4);
Robot myRobot;
Nav_Switch myNav( p21, p22, p23, p24, p25);

int i = 11;
int j = 11;
int C1 = 11;
int C2 = 32;
int C3 = 53;
int C4 = 74;
int C5 = 95;
int C6 = 116;
 
int main()
{   
    //Initialize Background
    uLCD.filled_rectangle(0, 0 , 127, 127, RED); 
    myRobot.drawOutline();
    while(i <= 116){  
        while(j <= 116){    
        myRobot.drawHelper(i,j);
        j = j + 21;
        }
    j = 11;
    i = i + 21;
    }
    myRobot.drawFrog();
    
    //Auto-pilot Testing
    wait(1);
    myRobot.drawEraser();
    myRobot.moveForward();
    myRobot.drawFrog();
    wait(1);
    myRobot.drawEraser();
    myRobot.moveForward();
    myRobot.drawFrog();
    wait(1);
    myRobot.drawEraser();
    myRobot.moveLeft();
    myRobot.drawFrog();
    wait(1);
    myRobot.drawEraser();
    myRobot.moveBackward();
    myRobot.drawFrog();
     
    //Begin Processes    
    while(1) {
        mbedleds = ~(myNav & 0x0F); //update leds with nav switch direction inputs
        if(myNav.fire()) mbedleds = 0x0F; 
        wait(0.02);
    }
}
