#include "temp_sensor.h"

const int addr = 0x90;
char config_t[3];
char temp_read[2];
float temp;

void temperature_config(void)//configures the temperature sensor
{
    config_t[0] = 0x01; //sets the array with the bytes
    config_t[1] = 0x60;
    config_t[2] = 0xA0;
    i2c_port.write(addr, config_t, 3); //sets up the sensor
    config_t[0] = 0x00; //sets a new value for the byte, the mode
    i2c_port.write(addr, config_t, 1);
}

float temperature()
{
    float sum = 0;
    for (int i = 0; i < 5; i++)
    {
    i2c_port.read(addr, temp_read, 2); //reads in two temperature values from the sensor
    temp = 0.0625 * (((temp_read[0] << 8)+temp_read[1]) >> 4); //turns them into degrees C
    sum += temp;
    }
    sum= sum/5;
    return sum;
}

