//MiniProject Day 7
//If tapped, the mbed will either read from a temperature sensor or the compass
#include "stdio.h"
#include "mbed.h"
#include "string"
#include "ILI932x.h"
#include "DmTouch.h"


#include "Arial12x12.h"
#include "Arial24x23.h"
//#include "pavement_48x34.h"
#include "mbed.h"
#include "compass_sensor.h"
#include "temp_sensor.h"
#include "acceler_sensor.h"
char orient=3; //orientation of the LCD and touch screen
Serial pc(USBTX, USBRX);
I2C i2c_port(p9, p10);                             // configures pins 9,10 for I2C communication with external sensors
float temp2;
int avg;
int choice = 0; //choice for the buttons on the touch screen: 1 = acceleration, 2 = compass, 3 = temperature
//const int addr1 = 0x53<<1;
DigitalOut led1(LED1);                             // configures mbed internal LED 1
DigitalOut led2(LED2);                             // configures mbed internal LED 2 
DigitalIn interupt(p20);     // sets accelerometer interupt as digital input at pin 20;
Timer sensor_timer;
DmTouch touch(DmTouch::DM_TFT24_104, p5, p6, p7, p8, p11);    
PinName dataBus[]= {p30, p29, p28, p27, p26, p25, p24, p23};
ILI932x myLCD(BUS_8, dataBus, p15, p17, p16, p14, p20, "myLCD", 240, 320); // Bus 8 bit, bus pin array, CS, RST, DC, WR, RD, name, xpixels, ypixels
bool down, lastDown;
uint16_t tx, ty;
Ticker inter_t; //Ticker for the touch screen
Timer t;
Timeout Response;
float accel_x,accel_y,accel_mag;
float compass_h; //compass heading
float main_data[2];

void UI() //the general UI code for the touch screen
{
                myLCD.set_font((unsigned char*) Arial24x23);
                myLCD.locate(60, 100);
                myLCD.printf("A"); //accleration label
                myLCD.circle(60,100,30,Blue); //acceleration button
                myLCD.locate(160, 100);
                myLCD.printf("C"); //compass label
                myLCD.circle(160,100,30,Green); //compass button
                myLCD.locate(260, 100);
                myLCD.printf("T"); //temp. label
                myLCD.circle(260,100,30,Red); //temp. button
}

void button()
{
    myLCD.cls(); //reset
    UI();
                            if (choice == 1) //acceleration
                            {
                                    myLCD.locate(60, 100);
                                    myLCD.printf("A");
                                    myLCD.fillcircle(60,100,30,Blue);
                                    getacceleration(main_data);
                                    accel_x = main_data[0];
                                    accel_y = main_data[1];
                                    accel_mag = sqrt((accel_x*accel_x)+(accel_y*accel_y));
                                    myLCD.locate(80,150);
                                    myLCD.printf("%f m/s^2",accel_mag);
                                 
                                }
                            if (choice == 2) //compass
                            {
                                    myLCD.locate(160, 100);
                                    myLCD.printf("C");
                                    myLCD.fillcircle(160,100,30,Green);
                                    compass_h = compass_n();
                                    myLCD.locate(80, 150);
                                    myLCD.printf("%f degrees N", compass_h);
                                    //compass
                                }
                            if (choice == 3) //temperature
                            {
                                    myLCD.locate(260, 100);
                                    myLCD.printf("T");
                                    myLCD.fillcircle(260,100,30,Red);
                                    temp2 = temperature();
                                    myLCD.locate(80, 150);
                                    myLCD.printf("%f C", temp2);
                                }
}
  
int main() {
         myLCD.set_orientation(orient); //orientation of the screen
         myLCD.set_font((unsigned char*) Arial24x23); //font
        touch.setOrientation(orient); //orientation of the touch screen
        down = false; //down portion of the touch screen
        lastDown = false; //last down -- what down was last time
        tx = (uint16_t)0; //x-coordinates of the touch screen
        ty = (uint16_t)0; //y-coordinates of the touch screen
        //char sensorData[1];
        led1 = 0;
        led2 = 0;
        t.start();
        UI(); //sets the the UI
        touch.init(); //initializes touch screen
        compass_config();
        temperature_config();
        configure_acceleration();
        while(1){
            //myLCD.foreground(Black);
             //myLCD.background(White);   

            t.reset();
            while(t.read()<10)
            {
            touch.readTouchData(tx, ty, down); //reads in touch screen coordinates
                        if (down)
                        {
                            if(tx >= 30 && tx <= 90 && ty >= 70 && ty <= 130) //if the acceleration button is pressed
                            {
                                    if (choice == 2 || choice == 3) //if other buttons were pushed before
                                    {
                                        myLCD.cls(); //reset
                                        UI();
                                    }
                                    myLCD.fillcircle(60,100,30,Blue); //establish which button is pushed -- "highlight it"
                                    myLCD.locate(60, 100);
                                    myLCD.printf("A");
                                    choice = 1;
                            }
                            if(tx >= 130 && tx <= 190 && ty >= 70 && ty <= 130) //if the compass button is pressed
                            {
                                    if (choice == 1 || choice == 3) //if other buttons were pushed before
                                    {
                                        myLCD.cls(); //reset
                                        UI();
                                    }
                                    myLCD.fillcircle(160,100,30,Green); //establish which button is pushed
                                    myLCD.locate(160, 100);
                                    myLCD.printf("C");
                                    choice = 2;
                                    
                            }
                            if(tx >= 230 && tx <= 290 && ty >= 70 && ty <= 130) //if the temperature button is pressed
                            {
                                    if (choice == 1 || choice == 2) //if any other buttons were pushed before
                                    {
                                        myLCD.cls(); //reset
                                        UI();
                                    }
                                    myLCD.fillcircle(260,100,30,Red); //establish which button is pushed
                                    myLCD.locate(260, 100);
                                    myLCD.printf("T");
                                    choice = 3;
                            }
                        }
                        else if (lastDown)
                        {
                            button();
                        }
                    wait(0.040);
                    lastDown = down;
                    }
                    inter_t.attach(&button,10);
                    } 
                }



    
