
//V1.1 Changes:
//Added 2ms delay for clear display function
//Added Return home in clear display function


//INFO

//Made for MBED LPC1768
//Made for EA W082-XLG In SPI mode (8x2 Oled display)
//Also works with other Oled displays

//Default Ports: (For LPC1768)
//p5 = mosi
//p6 = miso
//p7 = sck
//p8 = cs

//  8x2 display cursor location
// |---------------------------------------|
// |  1 |  2 |  3 |  4 |  5 |  6 |  7 |  8 |
// |---------------------------------------|
// | 65 | 66 | 67 | 68 | 69 | 70 | 71 | 72 |
// |---------------------------------------|

//IF Degree Symbol is desired, write DEG instead of the symbol, it will display the ° symbol. Example: DispCharacter(DEG); //Writes ° to display


//FUNCTIONS:

//OpenDisplay();  //Configures the display, should be run at startup in main routine, Clears display and returns to (1,1)
//DispLocate(X,Y);  //For choosing where the cursor is located. X is the line position (1-8), Y is the line select (1 for first line, 2 is for second line)
//DispCharacter('X');  //For writing a single Character to the display
//DispLine("HELLO");  //For writing a string to the display, (max 8 bit)
 
//ClearDisp();  //For Clearing Display, also returns the cursor to home (1,1)
//DispReturn();  //For Returning the cursor to home (1,1)
//ShiftRight();  //Shifts the cursor one to the right
//ShiftLeft();  //Shifts the cursor one to the left




//Define Pins:
#define mosi p5
#define miso p6
#define sck  p7
#define DEG 0xD2 //IF Degree Symbol is desired, write DEG instead of the symbol, it will display the ° symbol. Example: DispCharacter(DEG); //Writes ° to display

DigitalOut cs(p8); //Chip select

//Define SPI connections:
SPI spi(mosi, miso, sck); // mosi, miso, sck 


//For Use in Main Routine:
void DispLocate(char Char1, char Char2); //For deciding location of cursor, for use in main routine
void ClearDisp(void); //Clears the display, also returns the cursor to home (1,1)
void DispReturn(void); //returns cursor to home (1,1)
void ShiftRight(void); //Shifts cursor right
void ShiftLeft(void); //Shifts cursor left
void DispCharacter(void); //For displaying a single character. Example: DispCharacter('A'); //Wrtites A on display
void DispLine(void); //For Writing Line to display. Example: DispLine("Hello"); //Writes Hello on the display


//Prototypes:
void DispConfig(char Char); //For sending command to configure the display, used in the OpenDisplay routine
void Delay2us(void); //2us delay, used as a small delay for setup purposes

//Init Oled Display:
void OpenDisplay(){
        
    //DigitalOut cs(p8); //Chip select
    cs = 1; //high at idle 
    
    spi.format(10,3); //10bit, high steady state clock
    spi.frequency(1000000); //1MHz spi clock 
    
    //Display init routine
    DispConfig(0x39); //function set european chararacter set
    DispConfig(0x08); //display off
    DispConfig(0x06); //entry mode set increment cursor by 1 not shifting display
    DispConfig(0x17); //Character mode and internel power on
    DispConfig(0x01); //clear display
    DispConfig(0x02); //return home
    DispConfig(0x0C); //display on
    
    wait_ms(10); //Time to stabilize (wont work without)
}


//Send single line to display
void DispLine(char textstr[]){
        
        char len = strlen(textstr);
        for(char i = 0; i < len; i++){
            
            cs = 0; //chip select to start data transmission
            
            spi.write(0x200 | textstr[i]); //add 0x02 for character transmission
            
            cs = 1; //chip select to end data transmission
            
            Delay2us(); //small delay for cs to stabilize
        }
        
    }
    

void DispCharacter(char instruction){
    
        cs = 0; //chip select to start data transmission
        
        spi.write(0x200 | instruction); //add 0x02 for character transmission
        
        cs = 1; //chip select to end data transmission
        
        Delay2us(); //small delay for cs to stabilize
        
    }


//Send single character to display
void DispConfig(char instruction){
        
        cs = 0; //chip select to start data transmission
        
        spi.write(instruction);
        
        cs = 1; //chip select to end data transmission
        
        Delay2us(); //small delay for cs to stabilize
    }


//Locate Cursor
void DispLocate(char X, char Y){
        
        DispReturn(); //Return the cursor to home
        
        char tempX;
        tempX = X;
        char tempY;
        tempY = Y;
        
        //Shift to next line (64 times to the right)
        if(tempY > 1){
               for(int i = 0; i < 64; i++){
               ShiftRight();    
            }
        }
        
        //Decides how many times the cursor is shifted
        while(tempX > 1){
            tempX--;
            ShiftRight();
        }
    }


//Toggle Chipselect
void Chipselect(){
        
        cs = !cs; 
    }


void Delay2us(){
    
        wait_us(2); //small delay for cs to stabilize
    }

    
void ClearDisp(){
    
        DispConfig(0x01); //Clear Display, Sets DDRAM-address 0 into adresscounter
        wait_ms(2); //wait a little, wont work without
        DispReturn(); //Returns cursor home
        
    }

    
void DispReturn(){
        
        DispConfig(0x02); //Returns the cursor to home       
    }


void ShiftRight(){
    
        DispConfig(0x14); //Shift cursor right
        Delay2us();
    }


void ShiftLeft(){
    
        DispConfig(0x10); //Shift cursor left
        Delay2us();
    }