#include "mbed.h"
#include "nRF24L01P.h"

Serial pc(USBTX,USBRX);
nRF24L01P my_nrf24l01p(PTD2,PTD3,PTD1,PTD0,PTD5,PTD4);//MOSI,MISO,SCK,CSN,CE,IRQ
DigitalOut rled(LED1);


int main() 
{
    char count[2];
    char TxDataCnt;
    char temp;
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2440);//This is taken in MHz
    //Display the default setup of the nRF24L10+ chip
    pc.printf("nRF24L10+ Frequency      : %d MHz \r \n",my_nrf24l01p.getRfFrequency());
    pc.printf("nRF24L10+ Output Power   : %d dBm \r \n",my_nrf24l01p.getRfOutputPower());
    pc.printf("nRF24L10+ Data Rate      : %d kbps \r \n",my_nrf24l01p.getAirDataRate());
    pc.printf("nRF24L10+ Tx Address     : 0x%010llX\r\n", my_nrf24l01p.getTxAddress());
    pc.printf("nRF24L10+ Rx Address     : 0x%010llX\r\n", my_nrf24l01p.getRxAddress());
    
    
    pc.printf("Simple Transmitter (0 - 9 Counter)");
    TxDataCnt = 2;
    my_nrf24l01p.setTransferSize(TxDataCnt);
    
    my_nrf24l01p.enable();
    
    count[0] = 0x01;
    count[1] = 0x01;
    
    while(1) 
    {
        //Send the transmit buffer via the nRF24L01+
        temp = my_nrf24l01p.write(NRF24L01P_PIPE_P0,count,TxDataCnt);//Returns the number of bytes were sent.
        pc.printf("Sending %d - %d %d \r \n",temp,count[0],count[1]);
        
        //Togle LED1 (to help debug Host -> nRF24L01+ communication)
        rled = !rled;
        
        count[1]++;
        
        wait(1);       
    }
}
