/* Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @section DESCRIPTION
 *
 * Send command to Sigfox
 *
 */
#ifndef SIGFOX_H
#define SIGFOX_H

#include "ATParser.h"
#include "mbed.h"

// https://www.disk91.com/2016/technology/sigfox/test-of-sigfox-wisol-wssfm10r1-module/

typedef struct _sigfoxvoltage {
    double current;
    double last;
} sigfoxvoltage_t;

class Sigfox
{
    private:
    ATParser *_at;
    char ID[9];
    char PAC[17];
    
    public:
    Sigfox(ATParser &at) : _at(&at) {};
    
    bool ready();
    
    bool send(const char *data, char* response);
    /**
     * true = public
     * false = private
     */
    bool setKey(bool type);
    
    bool setPower(uint8_t power=15);
    
    bool setPowerMode(uint8_t power);
    
    void wakeup(DigitalInOut sig_rst, float time=0.2);
    
    bool saveConfig();
    
    char *getID();
    
    char *getPAC();
    
    sigfoxvoltage_t getVoltages();
    
    float getTemperature();
};

#endif  /* SIGFOX_H */