#include "mbed.h"
#include "DHT22.h"
#include "string.h"
#include "DS1820.h"

 
Serial pc(USBTX,USBRX); // tx, rx
Serial sigfox(PA_9,PA_10); // tx, rx
DHT22 dht22(D3);//pin pour la lecture du dht22 grove
DHT22 dht22Bis(D6);//pin pour la lecture du dht22 
AnalogIn IRSensor(A1);//Pin de lecture du capteur IR
DigitalOut led0(LED1);
DigitalOut led1(LED2);
double longi;
double lat;
const int MAX_PROBES = 1;
DS1820 probe[1] = {A4};



//Fonction lecture des donneé sigfox

 
int main() {
  
   int humExt;  // humidité intérieur dst22
   int tempExt; // température extérieur dst22
   int humInt;  // humidité intérieur dst22
   int tempInt; // température intérieur dst22
   int i;
   int devices_found=0;
   int tempDs; //tempérarure de la sonde Ds18B20;
   
    pc.baud(9600);
    sigfox.baud(9600);
    
    pc.printf("TEST\r\n");
    wait(0.5);

    //partie declarative DS18B20
    pc.printf("Started\r\n");
    pc.printf("search_ROM_setup\r\n");
    probe[0].search_ROM_setup();
    pc.printf("search_ROM\r\n");
 
     while (probe[devices_found].search_ROM() and devices_found<MAX_PROBES-1)
          devices_found++;
    
    // If maximum number of probes are found,
    // bump the counter to include the last array entry
    if (probe[devices_found].ROM[0] != 0xFF)
        devices_found++;
    pc.printf("devices found:%d\r\n",devices_found);
    
        //Fin de la partie declarative DS18B20   
        
    while(1) {
     char donnee[] = "AT$SF=";
     wait(1);
     pc.printf("TEST4\r\n");
     
   //  lecture du DHT22 grove
            
        dht22.sample() ;
        humExt=dht22.getHumidity()/10.0;
        tempExt=dht22.getTemperature()/10.0;
        pc.printf("temperature: %d humidity: %d\n\r",tempExt,humExt);
        
        //lecture du DHT22 simple Intérieure 
      
        dht22Bis.sample(); 
        humInt=dht22Bis.getHumidity()/10.0;
        tempInt=dht22Bis.getTemperature()/10.0;
        pc.printf("temperature1: %d humidity1: %d\n\r",tempInt,humInt);
      
        //mesure de la distance 
      
             //3.1V at 4cm to 0.3V at 30cm. 
       float a = IRSensor;// 1=4cm 0=30cm
       //pc.printf("IR sensor reads %2.2f\n ", a);
       float v=2.8*a;
      //  pc.printf("\r ANALOGIN %2.2f v \n ", v);
       float l= 10*((12/v)-0.42);
     
       pc.printf("\rDistance is %2.2f mm \n ", l); // print and convert to distance by taking x=0->1 and 26*x+4
       float x=193-l;//218
       float f= 4*(2.913*x);//2.5
       int m = (f/(9.8));
       pc.printf("\la masse de la ruche est égale à %d Kg \n ",m); 
       
       //mesure de la température avec DS18B20

        probe[0].convert_temperature(DS1820::all_devices);
        for (i=0; i<devices_found; i++) {
            tempDs = probe[i].temperature('c');
            pc.printf("Device[%d]: %d \r\n",i,tempDs);
        }
       
       //fin de mesure de temperature avec DS18B20
    
      
        pc.printf("TEST5\r\n");

    
        
        
        if(humExt<=16){
           strcat(donnee,"0%x");
        }else {strcat(donnee,"%2x");}
        pc.printf(donnee,humExt);
         pc.printf("\n");
         
       if(humInt<=16){
           strcat(donnee,"0%x");
        }else {strcat(donnee,"%2x");}
        pc.printf(donnee,humExt,humInt);
         pc.printf("\n");
         
        if(tempDs<=16){
           strcat(donnee,"0%x");
        }else {strcat(donnee,"%2x");}
        pc.printf(donnee,humExt,humInt,tempDs);
         pc.printf("\n");
         
        if(m<=16){
        strcat(donnee,"0%x");
        }else {strcat(donnee,"%2x");}
        pc.printf(donnee,humExt,humInt,tempDs,m); 
         
         pc.printf("\n");     
          
        if(tempExt<=16){
           strcat(donnee,"0%x");
        }else {strcat(donnee,"%2x");}
        pc.printf(donnee,humExt,humInt,tempDs,m,tempExt);
        pc.printf("\n");
        
        if(tempInt<=16){
           strcat(donnee,"0%x ");
        }else {strcat(donnee,"%2x ");}
         pc.printf(donnee,humExt,humInt,tempDs,m,tempExt,tempInt);
         pc.printf("\n");
         sigfox.printf(donnee,humExt,humInt,tempDs,m,tempExt,tempInt);
         pc.printf("\n");
         pc.printf(donnee,humExt,humInt,tempDs,m,tempExt,tempInt);
         
         // pc.printf(donnee);
          pc.printf("TEST6\r\n");
          led0 = 1;
          led1 = 1;
          wait (10);
          //wait(0.1); // wait 100 ms
        
                 //  LEDs OFF
                   led0 = 0;
                   led1 = 0;
      
      
                // wait(660);
        
           
    

    }
     
    

    


    
 
}




