#include "mbed.h"
#include "Motor.h"

Motor mr(p23, p19, p20); // pwm, fwd, rev
Motor ml(p24, p21, p22); // pwm, fwd, rev 

float r;
float l;


using namespace mbed;

Serial blue(p9, p10);


int main() {
    r = 0;
    l = 0;
    
    char bnum=0;
    char bhit=0;
    while(1) {
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    switch (bnum) {
                        case '5': //button 5 up arrow
                            if (bhit=='1') {
                                //add hit code here
                                printf("fwd");
                                l = 1.0;
                                r = 1.0;
                            } else {
                                //add release code here
                                l = 0.0;
                                r = 0.0;
                            }
                            break;
                        case '6': //button 6 down arrow
                            if (bhit=='1') {
                                //add hit code here
                                printf("bwd");
                                l = -1.0;
                                r = -1.0;
                            } else {
                                //add release code here
                                l = 0.0;
                                r = 0.0;
                            }
                            break;
                        case '7': //button 7 left arrow
                            if (bhit=='1') {
                                //add hit code here
                                printf("left");
                                l = 1.0;
                                r = -1.0;
                            } else {
                                //add release code here
                                l = 0.0;
                                r = 0.0;
                            }
                            break;
                        case '8': //button 8 right arrow
                            if (bhit=='1') {
                                //add hit code here
                                printf("right");
                                l = -1.0;
                                r = 1.0;
                            } else {
                                //add release code here
                                l = 0.0;
                                r = 0.0;
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
        mr.speed(l);
        ml.speed(r);
        printf("Left:%f Right:%f\n", l, r);
    }
}
