#include "mbed.h"
#include "motordriver.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "Speaker.h"
#include "rtos.h"
Motor m1(p22, p6, p5, 1); // pwm, fwd, rev, can brake left most motor (a)
Motor m2(p23, p7, p8, 1); //right most motor (b)
SDFileSystem sd(p11, p12, p13, p14, "sd"); // the pinout on the mbed Cool Components workshop board
AnalogOut DACout(p18); //set up analog out
wave_player waver(&DACout); //set up wave_player, with DACout as input to the funciton
Serial blue(p9,p10); //used p13 and p14 before

//instantiate Ins and Outs
InterruptIn detector(p25);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut laser(p20);
DigitalIn shot(p26);


volatile bool laserstate = false;
volatile bool downstate = false;

void gothit_isr() { // runs when robot gets shot
    downstate = true;
}
//thread deals with shooting/movement (communication with bluetooth chip)
void movement_thread(void const *args) {
     while(1) {
        char bnum=0;
        char bhit=0;
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    switch (bnum) {
                        case '1': //number button 1
                            if (bhit=='1') {
                                //led1 = 1;
                            } else {
                                //led1 = 0;
                            }
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                               // led2 = 1;
                            } else {
                               // led2 = 0;
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                               // led3 = 1;
                            } else {
                               // led3 = 0;
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                               // led4 = 1;
                            } else {
                                //led4 = 0;
                            }
                            break;
                        case '5': //button 5 up arrow
                            if (bhit=='1') {
                                //move robot forward when up button is pressed
                                m1.speed(0.95);
                                m2.speed(0.95);      
                            } else {
                                //stop robot when button is released
                                m1.speed(0.0);
                                m2.speed(0.0);
                            }
                            break;
                        case '6': //button 6 down arrow
                            if (bhit=='1') {
                                //move robot backward when down button is pressed
                                m1.speed(-0.95);
                                m2.speed(-0.95);
                            } else {
                                //stop robot when button is released
                                m1.speed(0.0);
                                m2.speed(0.0);
                            }
                            break;
                        case '7': //button 7 left arrow
                            if (bhit=='1') {
                                //move robot to the left by rotating both wheels when left button is pressed
                                m1.speed(-0.75);
                                m2.speed(0.75);
                            } else {
                                //stop robot when button is released
                                m1.speed(0.0);
                                m2.speed(0.0);
                            }
                            break;
                        case '8': //button 8 right arrow
                            if (bhit=='1') {
                                //move robot to the right by rotating both wheels when right button is pressed
                                m1.speed(0.75);
                                m2.speed(-0.75);
                            } else {
                                //stop robot when button is released
                                m1.speed(0.0);
                                m2.speed(0.0);
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
        Thread::yield();
    }
    
}

int main() {
    // main() handles the shooting and getting shot
    Thread thread(movement_thread);
    detector.rise(&gothit_isr); // rising edge interrupt, used to see if robot got hit
    while(1) {
        if(shot ==1){
            led4 =1; //turn led4 on if robot got shot
        }
        else{
            led4 =0;
            }
        if (downstate) { // robot got hit
            led1 = 1; //turn led1 if robot gets hit
            Thread::wait(3000); // movement_thread loops meanwhile, allowing for robot to still move when shot
            laserstate = false; // resets laser so that laser cannot shoot
            downstate = false; //resets downstate so that robot can be hit again
            led1 =0;
            }
        if (laserstate) { // robot is shooting
            led2 = 1; //led2 turns on when shooting
            laser = 1;
            Thread::wait(250); // movement_thread loops meanwhile
            laserstate = false;
            laser = 0;
            led2 = 0;
            }
        Thread::yield(); // movement_thread runs once
    }
}